package gov.va.genisis2.bs.data.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * Bookmark - Stores data associated with a bookmark
 * @author PII
 */
@Entity
@Table(name = "bookmarks")
public class Bookmark implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name = "id")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private int bookmarkId;
	
	@Column(name = "concept_name")
	private String conceptName;
	
	@Column(name = "concept_uri")
	private String conceptUri;
	
	@Column(name = "created_by")
	private String username;
	
	@OneToMany(fetch = FetchType.EAGER, mappedBy = "bookmark")
	@Fetch(FetchMode.SELECT)
	private List<Label> labels;
	/**
	 * @return the conceptId
	 */
	public int getBookmarkId() {
		return bookmarkId;
	}

	/**
	 * @param conceptId the concept_id to set
	 */
	public void setBookmarkId(int bookmarkId) {
		this.bookmarkId = bookmarkId;
	}

	/**
	 * @return the bookmark_name
	 */
	public String getConceptName() {
		return conceptName;
	}

	/**
	 * @param bookmarkName the bookmark_name to set
	 */
	public void setConceptName(String conceptName) {
		this.conceptName = conceptName;
	}

	/**
	 * @return the conceptUri
	 */
	public String getConceptUri() {
		return conceptUri;
	}

	/**
	 * @param conceptUri the conceptUri to set
	 */
	public void setConceptUri(String conceptUri) {
		this.conceptUri = conceptUri;
	}

	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username the username to set
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * @return the labels
	 */
	public List<Label> getLabels() {
		return labels;
	}

	/**
	 * @param labels the labels to set
	 */
	public void setLabels(List<Label> labels) {
		this.labels = labels;
	}
}
