import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { CookieService } from 'ngx-cookie-service';
import { NgRedux } from 'ng2-redux';
import { IAppState } from '../store';

import { environment } from '../../environments/environment';
import {
  SET_SESSION,
  FETCH_BOOKMARKS,
  FOCUS_ON
} from '../actions';

import {
RESEARCHER_ROLE,
TERMINOLOGIST_ROLE,
} from '../constants';

import { BookmarkServices } from '../services/bookmark-services';

@Injectable()
export class SystemServices {
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private http: Http,
    private cookieServices: CookieService,
    private bookmarkServices: BookmarkServices) {}

    // this.cookieService.set( 'Test', 'Hello World' );
    // this.cookieValue = this.cookieService.get('Test');

    getState() {
      return this.ngRedux.getState();
    }

    focusOn(element, timeOverride = null) {
      this.ngRedux.dispatch({
        type: FOCUS_ON,
        payload: ''
      });
      setTimeout(()=> {
        this.ngRedux.dispatch({
          type: FOCUS_ON,
          payload: element
        });
      }, (timeOverride || 500));
    }

    postMessageUpdate() {
      window.top.postMessage({cmd: 'update_all'}, '*');
    }

    async validateSSO() {
      if (environment.production && this.getState().system.environment.production) {
        await this.http.get('/').subscribe((response: Response) => {
          const clientSDn = response.headers.get('SSL_CLIENT_S_DN');
          if (clientSDn === undefined || clientSDn === null) {
            return false;
          } else  {
            const parsedClientSDn = this.parseClientSDn(clientSDn);
            if (this.validateClientSDn(parsedClientSDn)) {
              // Set Cookie
              this.cookieServices.set( 'username', parsedClientSDn['UID'] );
              this.setSession(parsedClientSDn['UID']);
              this.bookmarkServices.fetchAllBookmarks().subscribe(
                (response: Response) => {
                  this.ngRedux.dispatch({
                    type: FETCH_BOOKMARKS,
                    payload: JSON.parse(response.text()).response
                  });
                });
              return true;
            } else {
              return false;
            }
          }
        });
      } else {
        this.cookieServices.set('username', PII         ');
        PII                         ');
        this.bookmarkServices.fetchAllBookmarks().subscribe(
          (response: Response) => {
            this.ngRedux.dispatch({
              type: FETCH_BOOKMARKS,
              payload: JSON.parse(response.text()).response
            });
          });
        return true;
      }
    }

    parseClientSDn(ssl_client_s_din) {
      let clientSDn = {};
      // separate by spaces first
      if (ssl_client_s_din) {
        let headerArray = ssl_client_s_din.split(',');
        for (let i = 0; i < headerArray.length; i++) {
          let arr = headerArray[i].split('=');
          clientSDn[arr[0]] = arr[1];
        }
        return clientSDn;
      } else {
        return null;
      }     
    }

    validateClientSDn(clientSDn) {
      if (clientSDn['UID'] && clientSDn['UID'].length > 0 && clientSDn[
          'UID'].indexOf('@') >=
        0) {
        return true;
      }

      return false;    
    }

    async isAuthenticated() {
      //const username = this.cookieServices.get('username');
      const username = this.getState().system.session.username;
      if ((username !== undefined || username !== null) && username.length > 0) {
        return true;
      } else {
        return false;
      }
    }

    setSession(loggedInUsername) {
      if ((loggedInUsername !== undefined || loggedInUsername !== null) && loggedInUsername.length > 0) {
        this.ngRedux.dispatch({
          type: SET_SESSION,
          payload: {username: loggedInUsername, userRole: RESEARCHER_ROLE}
        });
      } 
    }

    async fetchBookmarks(): Promise<any> {
      let response = await this.bookmarkServices
      .fetchAllBookmarks().toPromise();
      return response.text();
    }
}
