import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { environment } from '../../environments/environment';
import {Observable} from 'rxjs/Observable';
import { NgRedux } from 'ng2-redux';
import { ApiServices } from './api-services';
import { BookmarkServices } from './bookmark-services';
import { TemplatingServices } from './templating-services';
import { SystemServices } from './system-services';

import {
  FETCH_CONCEPTS,
  FETCHING_CONCEPTS,
  CLEAR_CONCEPTS,
  INITIALIZE_CONCEPT_SEARCH_META_DATA,
  UPDATE_CONCEPT_SEARCH_META_DATA,
  DISPLAY_CONCEPT_CARD_DETAIL,
  SET_CARD_DATA,
  UPDATE_CONCEPT_CARD_TAB_SELECTION,
  SET_CURRENT_CONCEPT_SELECTED,
  NEW_CONCEPT_HISTORY,
  ENABLE_CONCEPT_CARD_VIEW,
  CONCEPT_CARD_POPULATING,
  CONCEPT_CARD_POPULATED,
  RESET_ADD_MVP_STATE,
  PREVIOUS_CONCEPT_HISTORY,
  CLEAR_CONCEPT_CARD_STATE,
  FOCUS_ON,
  DISABLE_CONCEPT_CARD_VIEW,
  REMOVE_BOOKMARK,
  SET_CURRENT_BOOKMARK_SELECTED,
  UPDATE_FILTERED_LIST,
  ADD_BOOKMARK,
  UPDATE_CONCEPT_CARD_BOOKMARK_MESSAGE
} from '../actions';
import { IAppState } from '../store';

@Injectable()
export class ConceptServices {
  baseUri;
  private data: Observable<Array<any>>;
  constructor (
    private bookmarkServices: BookmarkServices,
    private templatingServices: TemplatingServices,
    private apiServices: ApiServices,
    private systemServices: SystemServices,
    private http: Http,
    private ngRedux: NgRedux<IAppState>) {

  //   let data : [{
  //     response: {
  //       name: 'mvpConceptName',
  //       uri: 'http://URL/mvp-schema#conceptUri',
  //       description: {
  //         definition: 'http://URL/mvp-schema#definition testing',
  //         altDefinition: [],
  //         synonyms: []
  //       },
  //       relationships: {
  //         superClasses: [
  //           {name: 'superClass1', uri: 'http://URL/mvp-schema#superClass1Uri'}
  //         ],
  //         subClasses: [
  //           {name: 'subclass1', uri: 'http://URL/mvp-schema#subclass1uri'
  //         }
  //         ]
  //       },
  //       meta: {
  //         interOntologyLinks: [],
  //         properties: [],
  //         relationships: []
  //       }
  //       }
  //   }];
  }

  getState() {
    return this.ngRedux.getState();
  }

  isBookmarked() {
    // this needs to change in mvp add
    const bookmarks = this.getState().bookmark.bookmarks;
    if (bookmarks.length > 0) {
      for (let bookmark of bookmarks) {
        if (bookmark.conceptUri === this.getCurrentConcept().uri) {
          return true;
        }
      }
    } else {
      return false;
    }
    return false;
  }
  
  conceptCardPopulated() {
    const state = this.getState().conceptCard;
    if (
      state.cardPopulated &&
      state.conceptHistory.length > 0 &&
      !state.mvpRemoving &&
      !state.mvpAdding) {
      return true;
    } else {
      return false;
    }
  }

  canPreviousConcept() {
    const conceptHistory = this.getState().conceptCard.conceptHistory;
    return conceptHistory.length > 1;
  }

  getCurrentConcept() {
    return this.getState().conceptSearch.selectedConcept;
  }

  getCurrentPageObjects(objects, currentIndexSelected) {
    const defaultMaxPages = 10;
    const yieldPageNumber = 999;
    const state = this.getState();
    let maxPages = state.conceptSearch.maxConceptSearchPages;
    if (currentIndexSelected > yieldPageNumber) {
      maxPages = 5;
    } else {
      maxPages = defaultMaxPages;
    }
    let newObjects = [];
    if (objects === null) {
      objects = state.conceptSearch.conceptSearchData.pageObjects;
    }
    const maxIndex = objects.length - 1;
    const projectedIndexLength = currentIndexSelected + maxPages;
    // we need to set these two variables based on information provided above
    let maxIteration = 0;
    let newIndex = 0;
    // Scenarios
    // 1. if projections exceed max length
    // 2. if projections do not exceed max length
    // 3. when adjusted does the delta exceed negative of 0?
    // 4. when adjusted does delta do not exceed negative of 0?
    if (projectedIndexLength > maxIndex) {
      // if projection exceeds max length
      maxIteration = maxIndex + 1;
      const delta = projectedIndexLength - maxIndex;
      if (currentIndexSelected - delta >= 0) {
        newIndex = (currentIndexSelected - delta) + 1;
      } else {
        newIndex = 0;
      }
    } else {
      // if maxlength exceeds projection
      maxIteration = projectedIndexLength;
      newIndex = currentIndexSelected;
    }
    for (let i=newIndex; i<maxIteration; i++) {
      newObjects.push(objects[i]);
    }
    return newObjects;
  }

  getPageObjects(numPages) {
    const objects = [];
    for(let i = 0; i < numPages; i++) {
      if (i === 0) {
        objects.push({
          pageNum: i+1,
          active: true 
        });
      } else {
        objects.push({
          pageNum: i+1,
          active: false 
        });       
      }
    }
    return objects;
  }

  populateConceptCard(concept, uri?) {
    let conceptUri = '';
    if (concept !== null) {
      conceptUri = concept.conceptUri;
    } else {
      conceptUri = uri;
    }
    const headers = this.apiServices.getHeader();

    const options = new RequestOptions({headers: headers});
    return this.http.get(
      this.apiServices.apiUrl() +
      '/concept-cards?conceptUri=' +
      encodeURIComponent(conceptUri), options
    );
  }

  fetchConcepts(query?) {
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers});
    if (query === undefined) {
      query = this.getState().conceptSearch.conceptSearchData.queryString;
    }
    return this.http.get(
     this.apiServices.apiUrl() + '/searches?searchPhrase=' + encodeURIComponent(query), options
    );
  }

  getDataElementList() {
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers});
    return this.http.get(
     this.apiServices.apiUrl() + '/dataElements/', options
    );
  }

  fetchConceptsUpdate(options) {
    this.ngRedux.dispatch({
      type: CLEAR_CONCEPTS
    })
    this.ngRedux.dispatch({
      type: FETCHING_CONCEPTS
    })
    const headers = this.apiServices.getHeader();
    const HeaderOptions = new RequestOptions({headers: headers});
    if (options.query === undefined) {
      options.query = encodeURIComponent(this.getState().conceptSearch.conceptSearchData.queryString);
    }
    return this.http.get(
     this.apiServices.apiUrl() + '/searches?searchPhrase=' + options.query + '&start=' + options.start, HeaderOptions
    ).subscribe(
      (response: Response) => {
      if (response.status === 200) {
        let rdata = JSON.parse(response.text());
        if (rdata.message && rdata.message.length > 0) {
          // return some message
        } else {
          this.ngRedux.dispatch({
            type: FETCH_CONCEPTS,
            payload: rdata.response.response.docs
          });
          // here I need to do something for initializing pagination data
          // I get back numFound and start - both are integers
          const numPages = Math.ceil(rdata.response.response.numFound / 20);
          let payload;
          if (options.init) {
            const pageObjects = this.getPageObjects(numPages);
            const currentPageObjects = this.getCurrentPageObjects(pageObjects, 0);
            payload = {
              queryString: options.query,
              numFound: rdata.response.response.numFound,
              start: rdata.response.response.start,
              numPages: numPages,
              currentPageNum: 1,
              pageObjects: pageObjects,
              currentPageObjects: currentPageObjects
            }
            this.ngRedux.dispatch({
              type: INITIALIZE_CONCEPT_SEARCH_META_DATA,
              payload: payload
            });
          } else {
            const currentPageObjects = this.getCurrentPageObjects(
              null,
              options.currentPageNum - 1);
            payload = {
              start: rdata.response.response.start,
              currentPageNum: options.currentPageNum,
              currentPageObjects: currentPageObjects
            }
            this.ngRedux.dispatch({
              type: UPDATE_CONCEPT_SEARCH_META_DATA,
              payload: payload
            });
          }
        }
      }
    }); 
  }

  fetchConceptNodes(concept) {
    const headers = this.apiServices.getHeader();
    let options = new RequestOptions({headers: headers});
    return this.http.get(
      'http://IP              /api/concepts/nodes/' + concept, options
    )

    // Expected json body rsponse would be along:
    // {
    //   success: true || false,
    //   message: 'if success false - we need mesage of error here',
    //   results: [
    //     {
    //       // include the root node in this selection here
    //     },
    //     ...
    //     {
    //       identifier: 'this could assist in parent and child',
    //       sub_class_of: 'name the identifier',
    //       data: {
    //         preferred_name: 'blargh',
    //         type: '????',
    //         uri: 'uri blargh',
    //         definitions: 'ajsd;fklajsdf'
    //       }
    //     }
    //   ]
    // }
  }

  fetchConceptCardData(concept) {
    // concept could be an uri maybe?
    const options = {};
    return this.http.get(
      'http://IP              /api/concepts/card/' + concept, options
    )

    // Excepted json body response would be the following:
    // {
    //   success: true || false,
    //   message: 'if success false - we need mesage of error here',
    //   results: {
    //     // This is where we should have the discussion of generalized
    //     // Card data that would be displayed for each "focused" concept
    //     // e.g. when we click on the search result concept - it will (1)
    //     // load the concept nodes (2) it will load the primary node concept
    //     // card data
    //     // WE NEED TO DEFINE THESE PROPERTIES HERE AND GET CLIENT SIGN OFF
    //     preferred_name: 'asd;klf;jasdf',
    //     primary_uri: 'asfjklasdf',
    //     child_counts: 'over 9000',
    //     definitions: ['asdklfjlsd', 'aklsdfjklasdf', 'askdfjklasdjf'],
    //     etc........
    //   }
    // }   
  }

  removeMvpProperty(mvpObj) {
    const mvpPrefix = 'http://URL/mvp-schema#';
    const rdfPrefix = 'http://www.w3.org/2000/01/rdf-schema#';
    var object;
    var predicate;
    var subject;
    var rootUri = '<' + this.getState().conceptCard.conceptCardData.uri + '>';
    if (mvpObj.type == 'InterOntologyLink') {
        subject = rootUri; 
        predicate = '<' + mvpPrefix + 'InterOntologyLink>';
        object =  '<' + mvpObj.uri + '>';
    } else if (mvpObj.type == 'SubClass') {
        subject = '<' + mvpObj.uri + '>'; 
        //predicate = '<' + rdfPrefix + 'subClassOf>';
        predicate = '<' + mvpPrefix + 'SubClassOf>';
        object =  rootUri;
    } else if (mvpObj.type == 'SuperClass') {
        subject = rootUri; 
        predicate = '<' + mvpPrefix + 'SubClassOf>';
        object =  '<' + mvpObj.uri + '>';
    } else if (mvpObj.type == 'Relationship') {
        subject = rootUri; 
        predicate = '<' + mvpObj.uri + '>';
        object =  '<' + mvpObj.value + '>';
     } else if (mvpObj.type == 'DataElement') {
        subject = rootUri; 
        predicate = '<' + mvpPrefix + 'MappingDataElement>';
        object =  '<' + mvpObj.value + '>';
     } else {
        subject = rootUri; 
        predicate = '<' + mvpObj.uri + '>';
        object =  mvpObj.value;
     }
    let data = {
        properties: [{
        s: subject, 
        p: predicate,
        o: object
        }]
      };
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers, body: data});
    return this.http.delete(this.apiServices.apiUrl() + '/update', options);
    // let headers = new Headers();
    // headers.append('Accept', 'application/json');
    // headers.append('Content-type', 'application/json');
    // const options = new RequestOptions({headers: headers, body: data});
    // return this.http.delete(this.apiServices.apiUrl() + '/update', options);

    // return new Observable(observer => {
    //   setTimeout(() => {
    //     observer.next({response: {success: true}});
    //   }, 1000);

    //   setTimeout(() => {
    //     observer.complete();
    //   }, 1000);
    // });
  }

  getCurrentCard() {
    return this.getState().conceptCard.conceptCardData;
  }

  reloadConceptCard(focusType) {
    const uri = this.getState().conceptCard.conceptCardData.uri;
    return this.populateConceptCard(null, uri)
            .subscribe((response: Response) => {
              if (response.status === 200) {
                const rdata = JSON.parse(response.text());
                this.ngRedux.dispatch({
                  type: RESET_ADD_MVP_STATE
                });
                this.ngRedux.dispatch({
                  type: SET_CARD_DATA,
                  payload: rdata.response
                });
                this.ngRedux.dispatch({
                  type: SET_CURRENT_CONCEPT_SELECTED,
                  payload: rdata.response
                });
                this.ngRedux.dispatch({
                  type: FOCUS_ON,
                  payload: focusType
                });
                this.ngRedux.dispatch({
                  type: DISPLAY_CONCEPT_CARD_DETAIL
                });
              }
            });
  }

  previousConcept() {
    if (this.getState().conceptCard.conceptHistory.length > 0) {
      this.ngRedux.dispatch({
        type: PREVIOUS_CONCEPT_HISTORY
      });
      this.ngRedux.dispatch({
        type: CONCEPT_CARD_POPULATING
      });
      const currentHistory = this.getState().conceptCard.conceptHistory;
      const previous = currentHistory[currentHistory.length - 1];
      if (currentHistory.length > 0) {
        setTimeout(() => {
          this.ngRedux.dispatch({
            type: SET_CARD_DATA,
            payload: previous
          });
          this.ngRedux.dispatch({
            type: SET_CURRENT_CONCEPT_SELECTED,
            payload: previous
          });
          this.templatingServices.setTemplateStates();
          this.ngRedux.dispatch({
            type: CLEAR_CONCEPT_CARD_STATE
          });
          this.ngRedux.dispatch({
            type: CONCEPT_CARD_POPULATED
          });
          this.systemServices.focusOn('conceptCardTitle');
        }, 1000);
      } else {
        this.ngRedux.dispatch({
          type: CLEAR_CONCEPT_CARD_STATE
        });
      }
    } else {
      this.ngRedux.dispatch({
        type: CLEAR_CONCEPT_CARD_STATE
      });
    }
  }

  getConcept(uri) {
    this.ngRedux.dispatch({
      type: CONCEPT_CARD_POPULATING
    });
    // this.systemServices.focusOn('conceptCardPopulating');
    // this.systemServices.focusOn('conceptCardTitle');
    /* Note: change this method to call populateConceptCard() after API property for URI is in sync */
    this.populateConceptCard(null, uri)
    .subscribe(
      (response: Response) => {
        if (response.status === 200) {
          let rdata = JSON.parse(response.text());
          // rdata.response.ontologyName = 'MDDVS';
          this.ngRedux.dispatch({
            type: UPDATE_CONCEPT_CARD_TAB_SELECTION,
            payload: 'description'
          });
          this.ngRedux.dispatch({
            type: SET_CARD_DATA,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: SET_CURRENT_CONCEPT_SELECTED,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: NEW_CONCEPT_HISTORY,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: RESET_ADD_MVP_STATE
          });
          // if (this.templatingServices.currentConceptHasOverride()) {
            // build tab data into conceptCard redux state
            this.templatingServices.setTemplateStates();
          // }
          this.ngRedux.dispatch({
            type: CONCEPT_CARD_POPULATED
          });
          this.ngRedux.dispatch({
            type: ENABLE_CONCEPT_CARD_VIEW
          });
          this.systemServices.focusOn('conceptCardTitle', 2000);
          this.setBookmarkMessage(rdata.response.nameWithOntologyName);
        }
    });
  }

  isActiveLink(uri) {
    return uri != null && uri.indexOf('http://') > -1;
  }

  setBookmarkMessage(bookmarkName) {
    const state = this.getState();
    const bookmarkCount = state.bookmark.bookmarks.length;
    const message = ` ${bookmarkName} ${this.isBookmarkedMessage()} and bookmark list has ${bookmarkCount}`
    this.ngRedux.dispatch({
      type: UPDATE_CONCEPT_CARD_BOOKMARK_MESSAGE,
      payload: message
    });
  }

  isBookmarkedMessage() {
    return this.isBookmarked() ? 'is bookmarked' : 'is not bookmarked';
  }

  bookmarkConcept() {
    this.bookmarkServices
    .addBookmark()
    .subscribe((response: Response) => {
      if (response.status === 201) { //changed check to look for 201 response instead of a 200
        setTimeout(() => {
          const rdata = JSON.parse(response.text());
          this.ngRedux.dispatch({
            type: ADD_BOOKMARK,
            payload: rdata.response
          });
          this.setBookmarkMessage(rdata.response.conceptNameWithOntologyName);
          this.systemServices.focusOn('conceptCardTitle');
          this.systemServices.postMessageUpdate();
        }, 1000);
      }
    });
  }

  getBookmarkFromCurrentConcept() {
    const bookmarks = this.getState().bookmark.bookmarks;
    for (let bookmark of bookmarks) {
      if (bookmark.conceptUri === this.getCurrentConcept().uri) {
        return bookmark;
      }
    }
    return null;
  }

  unBookmarkConcept() {
    const bookmark = this.getBookmarkFromCurrentConcept();
    this.bookmarkServices
      .removeBookmark(bookmark.bookmarkId)
      .subscribe((response: Response) => {
        if (response.status === 200) {
          setTimeout(() => {
            const rdata = JSON.parse(response.text());
            this.ngRedux.dispatch({
               type: SET_CURRENT_BOOKMARK_SELECTED,
               payload: bookmark
            });
            this.ngRedux.dispatch({
              type: REMOVE_BOOKMARK,
              payload: rdata.response
            });
            this.ngRedux.dispatch({
              type: UPDATE_FILTERED_LIST
            });
            this.setBookmarkMessage(bookmark.conceptNameWithOntologyName);
            this.systemServices.focusOn('conceptCardTitle');
            this.systemServices.postMessageUpdate();
          }, 1000);
        }
      });
  }

  disableConceptCard() {
    this.ngRedux.dispatch({
      type: DISABLE_CONCEPT_CARD_VIEW
    });
    this.ngRedux.dispatch({
      type: FOCUS_ON,
      payload: 'conceptCardNavIcon'
    })
  }

  returnHasMappingAsterisk(concept) {
    return this.hasMappings(concept) ? '*' : '';
  }

  hasMappings(concept) {
    return concept.hasMapping;
  }

  hasMappingsMessage(concept) {
    return this.hasMappings(concept) ? ' and has mappings' : ' and has no mappings';
  }

  isDataElementMessage(concept) {
    return this.isBaseline(concept) ? ' is a data element ' : '';
  }

  isBaseline(concept) {
    return concept.conceptUri.indexOf('http://URL/baseline/') > -1
  }
}

