import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { NgRedux } from 'ng2-redux';
import { IAppState } from '../store';
import { ApiServices } from './api-services';

@Injectable()
export class BookmarkServices {
  private mockBookmarks: any[];
  //private username = 'researcher'; //set to researcher for now to get data from APIs
  constructor (
    private apiServices: ApiServices,
    private http: Http,
    private ngRedux: NgRedux<IAppState>) {
  }

  getState() {
    return this.ngRedux.getState();
  }

  getCount() {
    return this.getState().bookmark.bookmarks.length;
  }

  addBookmark() {
    const conceptSearch = this.getState().conceptSearch;
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers});
    const body = {
      username: this.getState().system.session.username, //this.username,
      conceptUri: conceptSearch.selectedConcept.uri,
      conceptName: conceptSearch.selectedConcept.name
    }
    return this.http.post(this.apiServices.apiUrl() + '/bookmarks', body, options);
  }

  removeBookmark(bookmarkId) {
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers});
    return this.http.delete(this.apiServices.apiUrl() + '/bookmarks/' + bookmarkId, options);
  }

    /* adding tag to bookmark, assumption: returns bookmark object */
  addTagToBookmark(tagName, bookmarkId) {
    let data = {
      username: this.getState().system.session.username, //this.username,
      name: tagName
    }
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers});
    return this.http.post(this.apiServices.apiUrl() + '/bookmarks/' + bookmarkId + '/labels', data, options);

  }

  removeTagFromBookmark(tagName, bookmarkId) {
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers});
    return this.http.delete(this.apiServices.apiUrl() + '/bookmarks/' + bookmarkId + '/labels?labelName=' + encodeURIComponent(tagName), options);
  }

  /* get list of bookmarks from API */
  fetchAllBookmarks() {
    const headers = this.apiServices.getHeader();
    const options = new RequestOptions({headers: headers});
    let username = encodeURIComponent(this.getState().system.session.username);
    return this.http.get(this.apiServices.apiUrl() + '/bookmarks/' + username, options);
  }
}
