import { tassign } from 'tassign';
import {
  SET_ENVIRONMENT,
  SET_ACTIVE_ICON,
  DISABLE_ACTIVE_ICON,
  SET_SESSION,
  FOCUS_ON,
  CHANGE_USER_ROLE,
} from '../actions';

function setEnvironment(state, action) {
  return tassign(state, {environment: action.payload});
}

function setActiveIcon(state, action) {
  return tassign(state, {
    activeIcon: action.payload
  });
}

function disableActiveIcon(state, action) {
  return tassign(state, {
    activeIcon: ''
  });
}

function setSession(state, action) {
  return tassign(state, { session: {
    username: action.payload.username, 
    userRole: action.payload.userRole
    }
  });
}

function focusOn(state, action) {
  return tassign(state, {
    focusedElement: action.payload
  });
}

function changeUserRole(state, action) {
  return tassign(state, {
    session: {
      username: state.session.username,
      userRole: action.payload
    }
  });
}

const INITIAL_STATE = {
  environment: {},
  activeIcon: 'search',
  allowableTabSelection: [
    'description',
    'relationships',
    'metadata',
    'mvp'
  ],
  focusedElement: '',
  session: {
    username: '',
    userRole: '',
  }
}

export default function systemReducer(state = INITIAL_STATE, action) {
  switch (action.type) {
    case SET_ENVIRONMENT:
      return setEnvironment(state, action);
    case SET_ACTIVE_ICON:
      return setActiveIcon(state, action);
    case DISABLE_ACTIVE_ICON:
      return disableActiveIcon(state, action);
    case SET_SESSION:
      return setSession(state, action);
    case FOCUS_ON:
      return focusOn(state, action);
    case CHANGE_USER_ROLE:
      return changeUserRole(state, action);
  }
  return state;
}