import { Component, OnInit } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../store';
import { } from '../../actions';
import { ConceptServices } from '../../services/concept-services';
import { TemplatingServices } from '../../services/templating-services';

@Component({
  selector: 'app-concept-templating',
  templateUrl: './concept-templating.component.html',
  styleUrls: ['./concept-templating.component.scss']
})
export class ConceptTemplatingComponent implements OnInit {
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices,
    private templateServices: TemplatingServices) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  getBookmarkMessage() {
    return this.getState().conceptCard.bookmarkMessage;
  }

  getConceptService() {
    return this.conceptServices;
  }

  getTemplateService() {
    return this.templateServices;
  }

  getMappings() {
    return this.templateServices.getMappingForCurrentConcept();
  }

  getSelectedPropertyMappings() {
    return this.templateServices.getSelectedPropertyMappingForCurrentConcept();
  }

  getTabIndexForActiveTab() {
    return this.templateServices.getTabIndexForActiveTab();
  }

  getConceptName() {
    return this.conceptServices.getCurrentConcept().nameWithOntologyName;
  }
}
