import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { } from '../../../../actions';

import { ConceptServices } from '../../../../services/concept-services';
import { TemplatingServices } from '../../../../services/templating-services';

@Component({
  selector: 'app-concept-templating-list',
  templateUrl: './concept-templating-list.component.html',
  styleUrls: ['./concept-templating-list.component.scss']
})
export class ConceptTemplatingListComponent implements OnInit {
  @Input() propertyMapping;
  @Input() propertyData;
  @Input() tindex;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices,
    private templatingServices: TemplatingServices) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  getConcept(propertyItem) {
    const uri = propertyItem.value || propertyItem.uri || propertyItem.propertyUri;
    this.conceptServices.getConcept(uri);
  }

  getProperties(propertyName) {
    const conceptCard = this.conceptServices.getCurrentCard();
    return conceptCard[propertyName];
  }

  hasData(propertyData) {
    return propertyData !== undefined && propertyData !== null && propertyData.length > 0;
  }

}
