import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';
import { } from '../../../actions';
import { ConceptServices } from '../../../services/concept-services';
import { TemplatingServices } from '../../../services/templating-services';

@Component({
  selector: 'app-concept-templating-content',
  templateUrl: './concept-templating-content.component.html',
  styleUrls: ['./concept-templating-content.component.scss']
})
export class ConceptTemplatingContentComponent implements OnInit {
  @Input() propertyMappings;
  @Input() tindex;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices,
    private templatingServices: TemplatingServices) {
  }

  ngOnInit() {
  }

  getPropertyData(propertyName) {
    const conceptCard = this.conceptServices.getCurrentCard();
    return conceptCard[propertyName];
  }
}
