import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { } from '../../../../actions';

import { ConceptServices } from '../../../../services/concept-services';
import { TemplatingServices } from '../../../../services/templating-services';
@Component({
  selector: 'app-concept-templating-columns',
  templateUrl: './concept-templating-columns.component.html',
  styleUrls: ['./concept-templating-columns.component.scss']
})
export class ConceptTemplatingColumnsComponent implements OnInit {
  @Input() propertyMapping;
  @Input() propertyData;
  @Input() tindex;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices,
    private templatingServices: TemplatingServices) { }

  ngOnInit() {
  }

  getColumnSizeClass(size) {
    return this.templatingServices.getColumnSize(size);
  }

  getConcept(uri) {
    this.conceptServices.getConcept(uri);
  }

  hasProperties(data) {
    return data !== null && data.length > 0 ? true : false;
  }
}
