import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { FOCUS_ON } from '../../../../actions';
import { ConceptServices } from '../../../../services/concept-services';
import { TemplatingServices } from '../../../../services/templating-services';
import { SystemServices } from '../../../../services/system-services';

@Component({
  selector: 'app-concept-templating-back-top',
  templateUrl: './concept-templating-back-top.component.html',
  styleUrls: ['./concept-templating-back-top.component.scss']
})
export class ConceptTemplatingBackTopComponent implements OnInit {
  @Input() tindex;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices,
    private templatingServices: TemplatingServices,
    private systemServices: SystemServices) {
  }

  ngOnInit() {
  }

  backToTop() {
    this.systemServices.focusOn('conceptCardTitle');
  }

}
