import { Component, OnInit } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';
import { 
  CLEAR_CONCEPTS,
  FETCHING_CONCEPTS,
  FETCH_CONCEPTS,
  UPDATE_CONCEPT_SEARCH_META_DATA,
  SET_CONCEPT_SEARCH_LAST_BUTTON,
  SET_CONCEPT_SEARCH_NEXT_BUTTON,
  SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
  SET_CONCEPT_SEARCH_FIRST_BUTTON

} from '../../../actions'

import { ConceptServices } from '../../../services/concept-services'

@Component({
  selector: 'app-list-pagination',
  templateUrl: './list-pagination.component.html',
  styleUrls: ['./list-pagination.component.scss']
})
export class ListPaginationComponent implements OnInit {
  @select(['system', 'focusedElement']) focusedElement;
  @select(['conceptSearch', 'conceptSearchData', 'currentPageObjects']) indexers;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices) {}

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  getCurrentPage() {
    return this.getState().conceptSearch.conceptSearchData.currentPageNum;
  }

  getNextPage() {
    const state = this.getState();
    const totalPageNumbers = state.conceptSearch.conceptSearchData.pageObjects.length
    if (this.getCurrentPage >= totalPageNumbers) {
      return totalPageNumbers;
    } else {
      return this.getCurrentPage() + 1;
    }

  }

  getCurrentAndNexPageMessage() {
    return `current page is ${this.getCurrentPage()} and next page will be ${this.getNextPage()}`
  }

  canInteract(option) {
    const state = this.getState().conceptSearch;
    switch(option) {
      case 'first':
        return state.canConceptSearchFirstButton;
      case 'last':
        return state.canConceptSearchLastButton;
      case 'previous':
        return state.canConceptSearchPreviousButton;
      case 'next':
        return state.canConceptSearchNextButton
      default:
        return false;
    }
  }

  setToFirst() {
    this.conceptServices.fetchConceptsUpdate({
      init: false,
      currentPageNum: 1,
      start: 0
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
      payload: true
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_LAST_BUTTON,
      payload: true
    });
  }

  setToLast() {
    const currentSearchData = this.getState().conceptSearch.conceptSearchData;
    const totalPages = currentSearchData.pageObjects.length
    let start = Math.ceil(20*totalPages);
    if (start >= currentSearchData.numFound) {
      start = Math.ceil(20*(totalPages - 1));
    }
    this.conceptServices.fetchConceptsUpdate({
      init: false,
      currentPageNum: totalPages,
      start: start
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_LAST_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
      payload: true
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
      payload: true
    });
  }

  setNext() {
    const currentSearchData = this.getState().conceptSearch.conceptSearchData;
    const currentPageNum = currentSearchData.currentPageNum;
    let maxPage = currentSearchData.pageObjects.length;
    let newPageNum = maxPage;
    // we have to check if we are already on last page
    if (currentPageNum === maxPage) {
      this.setStateForMaxPage();
    } else {
      if (currentPageNum + 1 < maxPage) {
        newPageNum = currentPageNum + 1;
      }
      const start = currentSearchData.start + 19 + 1;
      this.conceptServices.fetchConceptsUpdate({
        init: false,
        currentPageNum: newPageNum,
        start: start
      });
      if (newPageNum === maxPage) {
        this.setStateForMaxPage();
      } else {
        this.enableAllButtons();
      }
    }
  }

  setStateForMaxPage() {
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_LAST_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
      payload: true
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
      payload: true
    });    
  }

  setPrevious() {
    const currentSearchData = this.getState().conceptSearch.conceptSearchData;
    const currentPageNum = currentSearchData.currentPageNum;
    let newPageNum = 1;
    // we have to check if we are already on last page
    if (currentPageNum === 1) {
      this.setStateForFirstPage();
    } else {
      if (currentPageNum - 1 > 0) {
        newPageNum = currentPageNum - 1;
      }
      const start = currentSearchData.start - 19 - 1;
      this.conceptServices.fetchConceptsUpdate({
        init: false,
        currentPageNum: newPageNum,
        start: start
      });
      if (newPageNum === 1) {
        this.setStateForFirstPage();
      } else {
        this.enableAllButtons();
      }
    }
  }

  setStateForFirstPage() {
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
      payload: false
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
      payload: true
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_LAST_BUTTON,
      payload: true
    });
  }

  enableAllButtons() {
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
      payload: true
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
      payload: true
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
      payload: true
    });
    this.ngRedux.dispatch({
      type: SET_CONCEPT_SEARCH_LAST_BUTTON,
      payload: true
    });
  }


  getCurrentTotalPages() {
    return this.getState().conceptSearch.conceptSearchData.numPages;
  }

  conceptExists() {
    return this.getState().conceptSearch.concepts.length > 0
  }

}
