import { Component, OnInit, Input } from '@angular/core';
import { NgRedux } from 'ng2-redux';
import { Response } from '@angular/http';

import { IAppState } from '../../../../store';
import { 
  CLEAR_CONCEPTS,
  FETCHING_CONCEPTS,
  FETCH_CONCEPTS,
  UPDATE_CONCEPT_SEARCH_META_DATA,
  SET_CONCEPT_SEARCH_LAST_BUTTON,
  SET_CONCEPT_SEARCH_NEXT_BUTTON,
  SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
  SET_CONCEPT_SEARCH_FIRST_BUTTON
} from '../../../../actions'
import { ConceptServices } from '../../../../services/concept-services';

@Component({
  selector: 'app-item-pagination',
  templateUrl: './item-pagination.component.html',
  styleUrls: ['./item-pagination.component.scss']
})
export class ItemPaginationComponent implements OnInit {
  @Input() index;
  mouseOvered: boolean;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private conceptServices: ConceptServices) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  isActive(index) {
    return this.getState().conceptSearch.conceptSearchData.currentPageNum === index.pageNum
  }

  getConceptsFor(index) {
    const currentSearchData = this.getState().conceptSearch.conceptSearchData;
    // index.pageNum is the new selected pageNum
    let start = (index.pageNum - 1) * 20;
    this.conceptServices.fetchConceptsUpdate({
      init: false,
      currentPageNum: index.pageNum,
      start: start
    });
    if (index.pageNum === 1) {
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
        payload: true
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_LAST_BUTTON,
        payload: true
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
        payload: false
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
        payload: false
      });
    } else if (index.pageNum === currentSearchData.pageObjects.length) {
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
        payload: false
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_LAST_BUTTON,
        payload: false
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
        payload: true
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
        payload: true
      });
    } else {
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_NEXT_BUTTON,
        payload: true
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_LAST_BUTTON,
        payload: true
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
        payload: true
      });
      this.ngRedux.dispatch({
        type: SET_CONCEPT_SEARCH_FIRST_BUTTON,
        payload: true
      });
    }
  }

}
