import { Component, OnInit, Input, Injectable } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { Response } from '@angular/http';

import { ConceptServices } from '../../../services/concept-services';
import { TemplatingServices } from '../../../services/templating-services';
import { SystemServices } from '../../../services/system-services';

import {
  SET_CARD_DATA,
  SET_CURRENT_CONCEPT_SELECTED,
  CONCEPT_CARD_POPULATED,
  CONCEPT_CARD_POPULATING,
  NEW_CONCEPT_HISTORY,
  ENABLE_CONCEPT_CARD_VIEW,
  UPDATE_CONCEPT_CARD_TAB_SELECTION,
  RESET_ADD_MVP_STATE,
  FOCUS_ON,
} from '../../../actions';
import { IAppState } from '../../../store';

@Component({
  selector: 'app-concept-item',
  templateUrl: './concept-item.component.html',
  styleUrls: ['./concept-item.component.scss']
})
@Injectable()
export class ConceptItemComponent implements OnInit {
  @Input() concept;
  mouseOvered: boolean;
  expanded: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private conceptServices: ConceptServices,
    private templateServices: TemplatingServices,
    private ngRedux: NgRedux<IAppState>,
    private systemServices: SystemServices) {
    this.expanded = false
  }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  getNode(concept) {
    this.ngRedux.dispatch({
      type: CONCEPT_CARD_POPULATING
    })
    this.conceptServices
    .populateConceptCard(concept)
    .subscribe(
      (response: Response) => {
        if (response.status === 200) {
          const rdata = JSON.parse(response.text());
          // this.ngRedux.dispatch({
          //   type: UPDATE_CONCEPT_CARD_TAB_SELECTION,
          //   payload: 'description'
          // });
          this.ngRedux.dispatch({
            type: SET_CARD_DATA,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: SET_CURRENT_CONCEPT_SELECTED,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: NEW_CONCEPT_HISTORY,
            payload: rdata.response
          });
          this.ngRedux.dispatch({
            type: RESET_ADD_MVP_STATE
          });
          // if (this.templateServices.currentConceptHasOverride()) {
          //   // build tab data into conceptCard redux state
            this.templateServices.setTemplateStates();
          // }
          this.ngRedux.dispatch({
            type: CONCEPT_CARD_POPULATED
          });
          // setTimeout(() => {
            this.ngRedux.dispatch({
              type: ENABLE_CONCEPT_CARD_VIEW
            });
          // }, 1000);
          // this.ngRedux.dispatch({
          //   type: FOCUS_ON,
          //   payload: 'conceptCardTitle'
          // })
          this.systemServices.focusOn('conceptCardTitle');
          this.conceptServices.setBookmarkMessage(rdata.response.name);
        }
    });
  }

  isActiveConcept(concept) {
    if (concept.conceptUri === this.getState().conceptSearch.selectedConcept.uri) {
      return true;
    } else {
      return false;
    }
  }

  expandDefinitions() {
    setTimeout(() => {
      this.expanded = !this.expanded;
      this.systemServices.focusOn("expandDefinition" + this.concept.conceptUri);
      }, 500);
  }

  hasTruncation(concept) {
    return concept.definition !== undefined && concept.definition.length > 99;
  }

  hasDefinition(concept) {
    return concept.definition !== null && concept.definition !== undefined && concept.definition.trim().length > 0;
  }

  getButtonMessage() {
    return this.expanded ? 'see less' : 'see more';
  }

  parseDefinition(concept) {
    return this.hasDefinition(concept) ? concept.definition : 'No Definition';
  }

  getConceptSearchItemAriaLabel() {
    return 'Concept ' + this.concept.labelWithOntologyName +
     this.conceptServices.isDataElementMessage(this.concept) + this.conceptServices.hasMappingsMessage(this.concept);
  }

  isDataElement() {
    return this.conceptServices.isBaseline(this.concept);
  }

  hasAsterisk() {
    return this.conceptServices.returnHasMappingAsterisk(this.concept);
  }

}
