import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { MvpServices } from '../../../../services/mvp-services';

@Component({
  selector: 'app-mvp-add-interontologies',
  templateUrl: './mvp-add-interontologies.component.html',
  styleUrls: ['./mvp-add-interontologies.component.scss']
})
export class MvpAddInterontologiesComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
  @Input() mvpObject;
  selectedBookmark: any;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    public mvpServices: MvpServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  anyBookmarksExists() {
    return this.mvpServices.getMvpBookmarkedConceptList() != null && this.mvpServices.getMvpBookmarkedConceptList().length > 0; 
  }

  onSubmit() {
    if (this.selectedBookmark != null && this.selectedBookmark != "0" &&
      this.selectedBookmark.conceptUri != null &&
      this.selectedBookmark.conceptUri.length > 0) {
      this.mvpObject.object = this.selectedBookmark.conceptUri;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
