import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';
import { MvpServices } from '../../../services/mvp-services';
import { RoleServices } from '../../../services/role-services';

import {
  UPDATE_CONCEPT_CARD_TAB_SELECTION
} from '../../../actions';

@Component({
  selector: 'app-concept-card-relationships',
  templateUrl: './concept-card-relationships.component.html',
  styleUrls: ['./concept-card-relationships.component.scss']
})
export class ConceptCardRelationshipsComponent implements OnInit {
  @Input() relationships;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    public mvpServices: MvpServices,
    private roleServices: RoleServices) { }


  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }
  
  hasSuperClasses(objects) {
    return objects !== null && objects.length > 0;
  }

  hasSubClasses(objects) {
    return objects !== null && objects.length > 0;
  }

  getAddMvpState() {
    return this.getState().conceptCard.mvpAddState;
  }

  hasMvpAddRole(mvpAnnotation) {
    var mvpBooleanState = false;
    switch(mvpAnnotation) {
      case 'super-class':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddSuperClass;
        break;
      case 'sub-class':
        mvpBooleanState = this.getState().conceptCard.mvpAddState.canAddSubClass;
        break;
    }
    return this.roleServices.isTerminologist() && mvpBooleanState && this.mvpServices.isConceptMvp();
  }
}
