import { Component, OnInit, Injectable } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { IAppState } from '../../store';
import { BookmarkServices } from '../../services/bookmark-services';

import { SideNavigationService } from '../../services/side-navigation-service';
import { 
  FETCH_BOOKMARKS,
  BOOKMARK_ICON_FOCUSED, } from '../../actions';

@Component({
  selector: 'app-bookmark',
  templateUrl: './bookmark.component.html',
  styleUrls: ['./bookmark.component.scss']
})
@Injectable()
export class BookmarkComponent implements OnInit {

  constructor(

    private ngRedux: NgRedux<IAppState>,
  	private snService: SideNavigationService,
    private bookmarkService: BookmarkServices) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }
 
  disableActive() {
  	this.snService.disableActiveIcon('bookmarkListIcon');
  }
}
