import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';

@Component({
  selector: 'app-bookmark-list',
  templateUrl: './bookmark-list.component.html',
  styleUrls: ['./bookmark-list.component.scss']
})
export class BookmarkListComponent implements OnInit {
	@select(['bookmark', 'bookmarks']) bookmarks;

  constructor(private ngRedux: NgRedux<IAppState>) {
  }

  getState() {
  	return this.ngRedux.getState();
  }

  ngOnInit() {
  }

  bookmarkExists() {
    return this.getState().bookmark.bookmarks.length > 0;
  }

  selectBookmarkList() {
    return this.getState().bookmark.filteredBookmarks.length > 0 ?
      this.getState().bookmark.filteredBookmarks : this.getState().bookmark.bookmarks;
  }

}
