import { Component, OnInit, Input} from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { Response } from '@angular/http';
 
import { BookmarkServices } from '../../../../services/bookmark-services';
import { SystemServices } from '../../../../services/system-services';
import {
  SET_CURRENT_BOOKMARK_SELECTED,
  DELETE_BOOKMARK_TAG,
  ADD_FILTER_TAG,
  FILTERED_BOOKMARKS,
  UPDATE_SELECTED_TAG,
  UPDATE_FILTERED_LIST
} from '../../../../actions';


@Component({
  selector: 'app-bookmark-tag-item',
  templateUrl: './bookmark-tag-item.component.html',
  styleUrls: ['./bookmark-tag-item.component.scss']
})
export class BookmarkTagItemComponent implements OnInit {
  @Input() tag;
  @Input() bookmark;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private bookmarkServices: BookmarkServices,
    private systemServices: SystemServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  setFilteredBookmarkList() {
    this.ngRedux.dispatch({
      type: UPDATE_SELECTED_TAG,
      payload: this.tag
    });
    this.ngRedux.dispatch({
      type: UPDATE_FILTERED_LIST,
      payload: this.bookmark
    });
    this.systemServices.focusOn('clearTagFitlerButton');

  }

  /* assuming this returns the update bookmark without the removed tag */
  removeTag(tag) {
      this.bookmarkServices
        .removeTagFromBookmark(tag.name, this.bookmark.bookmarkId)
          .subscribe((response: Response) => {
            if (response.status === 200) {
              const rdata = JSON.parse(response.text());
              this.ngRedux.dispatch({
                type: DELETE_BOOKMARK_TAG,
                payload: rdata.response
              });
              this.ngRedux.dispatch({
                type: UPDATE_FILTERED_LIST,
                payload: rdata.response
              });
              this.systemServices.focusOn('addTagInputField' + this.bookmark.bookmarkId);
              this.systemServices.postMessageUpdate();
            }
      });
  }
}
