import { Component, OnInit, Input, Injectable } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { Response } from '@angular/http';

import { SystemServices } from '../../../services/system-services';
import { ConceptServices } from '../../../services/concept-services';
import { BookmarkServices } from '../../../services/bookmark-services';

import {
	SET_CARD_DATA,
  SET_CURRENT_CONCEPT_SELECTED,
  CONCEPT_CARD_POPULATED,
  CONCEPT_CARD_POPULATING,
  NEW_CONCEPT_HISTORY,
  SET_CURRENT_BOOKMARK_SELECTED,
  REMOVE_BOOKMARK,
  ADD_BOOKMARK_TAG,
  UPDATE_FILTERED_LIST,
  ENABLE_CONCEPT_CARD_VIEW,
  UPDATE_CONCEPT_CARD_TAB_SELECTION,
  RESET_ADD_MVP_STATE,
  FOCUS_ON,

} from '../../../actions';
import { IAppState } from '../../../store';

@Component({
  selector: 'app-bookmark-item',
  templateUrl: './bookmark-item.component.html',
  styleUrls: ['./bookmark-item.component.scss']
})
@Injectable()
export class BookmarkItemComponent implements OnInit {
	@Input() bookmark;
  @Input() tagName;
  mouseOvered: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
   // private conceptServices: ConceptServices,
  	private conceptServices: ConceptServices,
    private bookmarkServices: BookmarkServices,
    private systemServices: SystemServices,
  	private ngRedux: NgRedux<IAppState>) {
  }

  ngOnInit() {
  }

  getState() {
  	return this.ngRedux.getState();
  }

  getConcept(concept) {
    this.conceptServices
    .getConcept(concept.conceptUri);
    // this.ngRedux.dispatch({
    //   type: CONCEPT_CARD_POPULATING
    // });
    // this.conceptServices
    // .populateConceptCard(concept)
    // .subscribe(
    //   (response: Response) => {
    //     if (response.status === 200) {
    //       let rdata = JSON.parse(response.text());
    //       this.ngRedux.dispatch({
    //         type: UPDATE_CONCEPT_CARD_TAB_SELECTION,
    //         payload: 'description'
    //       });
    //       this.ngRedux.dispatch({
    //         type: SET_CARD_DATA,
    //         payload: rdata.response
    //       });
    //       this.ngRedux.dispatch({
    //         type: SET_CURRENT_CONCEPT_SELECTED,
    //         payload: rdata.response
    //       });
    //       this.ngRedux.dispatch({
    //         type: NEW_CONCEPT_HISTORY,
    //         payload: rdata.response
    //       });
    //       this.ngRedux.dispatch({
    //         type: RESET_ADD_MVP_STATE
    //       });
    //       this.ngRedux.dispatch({
    //         type: CONCEPT_CARD_POPULATED
    //       });
    //       this.ngRedux.dispatch({
    //         type: ENABLE_CONCEPT_CARD_VIEW
    //       });
    //       this.ngRedux.dispatch({
    //         type: FOCUS_ON,
    //         payload: 'conceptCardTitle'
    //       })
    //     }
    // });
  }

  addTag() {
    var inputTagName = this.tagName;
    if(!(inputTagName == null || inputTagName == '') 
      && !(this.bookmark.labels != null && this.bookmark.labels.find(label => label.name == inputTagName) != undefined)) {
      this.bookmarkServices
        .addTagToBookmark(inputTagName, this.bookmark.bookmarkId)
        .subscribe((response: Response) => {
          if (response.status ===  201) { //changed response status to be 201 instead of 200
            const rdata = JSON.parse(response.text());
            this.ngRedux.dispatch({
              type: SET_CURRENT_BOOKMARK_SELECTED,
              payload:this.bookmark
            });
            this.ngRedux.dispatch({
              type: ADD_BOOKMARK_TAG,
              payload: rdata.response
            });
            this.ngRedux.dispatch({
              type: UPDATE_FILTERED_LIST,
              payload: rdata.response
            });
            this.systemServices.focusOn('tag' + this.bookmark.bookmarkId + this.tagName);
            this.systemServices.postMessageUpdate();
          }
      });
     }
  }

  unBookmark(bookmark) {
    this.bookmarkServices
      .removeBookmark(bookmark.bookmarkId)
      .subscribe((response: Response) => {
        if (response.status === 200) {
          const rdata = JSON.parse(response.text());
          this.ngRedux.dispatch({
             type: SET_CURRENT_BOOKMARK_SELECTED,
             payload: bookmark
          });
          this.ngRedux.dispatch({
            type: REMOVE_BOOKMARK,
            payload: rdata.response //this.getState().bookmarks.indexOf(this.bookmark)
          });
          this.ngRedux.dispatch({
            type: UPDATE_FILTERED_LIST
          });
          this.systemServices.postMessageUpdate();
          this.systemServices.focusOn('bookmarkListIcon');
        }
      });
  }

  isActiveConcept(bookmark) {
    if (bookmark.conceptUri === this.getState().conceptSearch.selectedConcept.uri) {
      return true;
    } else {
      return false;
    }
  }

  getAriaLabel() {
    return 'populate concept card ' + this.bookmark.conceptNameWithOntologyName + 
    this.conceptServices.hasMappingsMessage(this.bookmark);
  }

  hasAsterisk() {
    return this.conceptServices.returnHasMappingAsterisk(this.bookmark);
  }


}
