import { BrowserModule } from '@angular/platform-browser';
import { NgModule, Inject } from '@angular/core';
import { HttpModule } from '@angular/http';
import { AngularFontAwesomeModule } from 'angular-font-awesome/angular-font-awesome';
import { FormsModule } from '@angular/forms';
import { NgRedux, NgReduxModule } from 'ng2-redux';
import { store, IAppState } from './store';
import { TruncateModule } from 'ng2-truncate';
import { CookieService } from 'ngx-cookie-service';

import { ApiServices } from './services/api-services';
import { SystemServices } from './services/system-services';
import { BookmarkServices } from './services/bookmark-services';
import { SideNavigationService } from './services/side-navigation-service';
import { ConceptServices } from './services/concept-services';
import { MvpServices } from './services/mvp-services';
import { RoleServices } from './services/role-services';
import { TemplatingServices } from './services/templating-services';

import { FocusDirective } from './directives/focus.directive';
import { PrimaryInputValidatorDirective } from './directives/primary-input-validator.directive';

import { AppComponent } from './app.component';
import { SideNavigationComponent } from './components/side-navigation/side-navigation.component';
import { TopNavigationComponent } from './components/top-navigation/top-navigation.component';
import { ConceptSearchComponent } from './components/concept-search/concept-search.component';
import { ConceptViewComponent } from './components/concept-view/concept-view.component';
import { ConceptCardComponent } from './components/concept-card/concept-card.component';
import { ConceptListComponent } from './components/concept-search/concept-list/concept-list.component';
import { ConceptItemComponent } from './components/concept-search/concept-item/concept-item.component';
import { ConceptCardDescriptionComponent } from './components/concept-card/concept-card-description/concept-card-description.component';
import { ConceptCardRelationshipsComponent } from './components/concept-card/concept-card-relationships/concept-card-relationships.component';
import { ConceptCardMetadataComponent } from './components/concept-card/concept-card-metadata/concept-card-metadata.component';
import { ConceptCardMvpComponent } from './components/concept-card/concept-card-mvp/concept-card-mvp.component';
import { BookmarkComponent } from './components/bookmark/bookmark.component';
import { BookmarkListComponent } from './components/bookmark/bookmark-list/bookmark-list.component';
import { BookmarkItemComponent } from './components/bookmark/bookmark-item/bookmark-item.component';
import { BookmarkToolbarComponent } from './components/bookmark/bookmark-toolbar/bookmark-toolbar.component';
import { ConceptCardRelationshipsSubsComponent } from './components/concept-card/concept-card-relationships/concept-card-relationships-subs/concept-card-relationships-subs.component';
import { ConceptCardRelationshipsSupersComponent } from './components/concept-card/concept-card-relationships/concept-card-relationships-supers/concept-card-relationships-supers.component';
import { BookmarkTagListComponent } from './components/bookmark/bookmark-item/bookmark-tag-list/bookmark-tag-list.component';
import { BookmarkTagItemComponent } from './components/bookmark/bookmark-item/bookmark-tag-item/bookmark-tag-item.component';
import { ListPaginationComponent } from './components/concept-search/list-pagination/list-pagination.component';
import { ItemPaginationComponent } from './components/concept-search/list-pagination/item-pagination/item-pagination.component';
import { ConceptCardMetadataInterontologyItemComponent } from './components/concept-card/concept-card-metadata/concept-card-metadata-interontology-item/concept-card-metadata-interontology-item.component';
import { ConceptCardMetadataPropertiesItemComponent } from './components/concept-card/concept-card-metadata/concept-card-metadata-properties-item/concept-card-metadata-properties-item.component';
import { ConceptCardMetadataRelationshipsItemComponent } from './components/concept-card/concept-card-metadata/concept-card-metadata-relationships-item/concept-card-metadata-relationships-item.component';
import { MvpRemoveComponent } from './components/concept-card/mvp-remove/mvp-remove.component';
import { MvpAddComponent } from './components/concept-card/mvp-add/mvp-add.component';
import { MvpAddDefinitionComponent } from './components/concept-card/mvp-add/mvp-add-definition/mvp-add-definition.component';
import { MvpAddAltDefinitionsComponent } from './components/concept-card/mvp-add/mvp-add-alt-definitions/mvp-add-alt-definitions.component';
import { MvpAddSynonymsComponent } from './components/concept-card/mvp-add/mvp-add-synonyms/mvp-add-synonyms.component';
import { MvpAddSuperClassesComponent } from './components/concept-card/mvp-add/mvp-add-super-classes/mvp-add-super-classes.component';
import { MvpAddSubClassesComponent } from './components/concept-card/mvp-add/mvp-add-sub-classes/mvp-add-sub-classes.component';
import { MvpAddInterontologiesComponent } from './components/concept-card/mvp-add/mvp-add-interontologies/mvp-add-interontologies.component';
import { MvpAddPropertiesComponent } from './components/concept-card/mvp-add/mvp-add-properties/mvp-add-properties.component';
import { MvpAddRelationshipsComponent } from './components/concept-card/mvp-add/mvp-add-relationships/mvp-add-relationships.component';
import { ConceptCardMetadataMappingDataElementsItemComponent } from './components/concept-card/concept-card-metadata/concept-card-metadata-mapping-data-elements-item/concept-card-metadata-mapping-data-elements-item.component';
import { MvpAddMappingDataElementsComponent } from './components/concept-card/mvp-add/mvp-add-mapping-data-elements/mvp-add-mapping-data-elements.component';
import { MvpAddMappingAlgorithmComponent } from './components/concept-card/mvp-add/mvp-add-mapping-algorithm/mvp-add-mapping-algorithm.component';
import { MvpAddMappingValidationComponent } from './components/concept-card/mvp-add/mvp-add-mapping-validation/mvp-add-mapping-validation.component';
import { FooterComponent } from './components/footer/footer.component';
import { AuthenticationComponent } from './components/authentication/authentication.component';
import { MvpAddCancelButtonComponent } from './components/concept-card/mvp-add/mvp-add-cancel-button/mvp-add-cancel-button.component';
import { MvpAddSubmitButtonComponent } from './components/concept-card/mvp-add/mvp-add-submit-button/mvp-add-submit-button.component';
import { ConceptTemplatingComponent } from './components/concept-templating/concept-templating.component';
import { ConceptTemplatingListComponent } from './components/concept-templating/concept-templating-content/concept-templating-list/concept-templating-list.component';
import { ConceptTemplatingColumnsComponent } from './components/concept-templating/concept-templating-content/concept-templating-columns/concept-templating-columns.component';
import { ConceptTemplatingTabsComponent } from './components/concept-templating/concept-templating-tabs/concept-templating-tabs.component';
import { ConceptTemplatingContentComponent } from './components/concept-templating/concept-templating-content/concept-templating-content.component';
import { ConceptTemplatingTextComponent } from './components/concept-templating/concept-templating-content/concept-templating-text/concept-templating-text.component';
import { DataElementListComponent } from './components/data-element-list/data-element-list.component';
import { ConceptTemplatingBackTopComponent } from './components/concept-templating/concept-templating-content/concept-templating-back-top/concept-templating-back-top.component';

@NgModule({
  declarations: [
    PrimaryInputValidatorDirective,
    FocusDirective,
    AppComponent,
    SideNavigationComponent,
    TopNavigationComponent,
    ConceptSearchComponent,
    ConceptViewComponent,
    ConceptCardComponent,
    ConceptListComponent,
    ConceptItemComponent,
    ConceptCardDescriptionComponent,
    ConceptCardRelationshipsComponent,
    ConceptCardMetadataComponent,
    ConceptCardMvpComponent,
    BookmarkComponent,
    BookmarkListComponent,
    BookmarkItemComponent,
    BookmarkToolbarComponent,
    ConceptCardRelationshipsSubsComponent,
    ConceptCardRelationshipsSupersComponent,
    BookmarkTagListComponent,
    BookmarkTagItemComponent,
    ListPaginationComponent,
    ItemPaginationComponent,
    ConceptCardMetadataInterontologyItemComponent,
    ConceptCardMetadataPropertiesItemComponent,
    ConceptCardMetadataRelationshipsItemComponent,
    MvpRemoveComponent,
    MvpAddComponent,
    MvpAddDefinitionComponent,
    MvpAddAltDefinitionsComponent,
    MvpAddSynonymsComponent,
    MvpAddSuperClassesComponent,
    MvpAddSubClassesComponent,
    MvpAddInterontologiesComponent,
    MvpAddPropertiesComponent,
    MvpAddRelationshipsComponent,
    ConceptCardMetadataMappingDataElementsItemComponent,
    MvpAddMappingDataElementsComponent,
    MvpAddMappingAlgorithmComponent,
    MvpAddMappingValidationComponent,
    FooterComponent,
    AuthenticationComponent,
    MvpAddCancelButtonComponent,
    MvpAddSubmitButtonComponent,
    ConceptTemplatingComponent,
    ConceptTemplatingListComponent,
    ConceptTemplatingColumnsComponent,
    ConceptTemplatingTabsComponent,
    ConceptTemplatingContentComponent,
    ConceptTemplatingTextComponent,
    DataElementListComponent,
    ConceptTemplatingBackTopComponent,
  ],
  imports: [
    BrowserModule,
    HttpModule,
    AngularFontAwesomeModule,
    FormsModule,
    NgReduxModule,
    TruncateModule,
  ],
  providers: [
    ApiServices,
    SystemServices,
    CookieService,
    SideNavigationService,
    ConceptServices,
    BookmarkServices,
    MvpServices,
    RoleServices,
    TemplatingServices,
  ],
  bootstrap: [AppComponent]
})
export class AppModule {
  constructor(
    apiService: ApiServices,
    ngRedux: NgRedux<IAppState>,
    ) {  
    ngRedux.provideStore(store);  
  }
}
