package gov.va.genisis2;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

import org.apache.log4j.Logger;

/**
 * Client to make HTTP requests
 * @author PII
 *
 */
public class HttpClient {

	private static final Logger LOGGER = Logger.getLogger(HttpClient.class);

	public HttpClient() {
	}

	public void sendingUpdate(String url, boolean post, String payload) {

		try {
			URL obj = new URL(url);
			HttpURLConnection con = (HttpURLConnection) obj.openConnection();

			// Setting basic post request
			if (post)
				con.setRequestMethod("POST");
			else 
				con.setRequestMethod("DELETE");
			
			con.setRequestProperty("Accept-Encoding", "application/json");
			con.setRequestProperty("Content-Type", "application/json");

			con.setDoOutput(true);
			DataOutputStream wr = new DataOutputStream(con.getOutputStream());
			wr.writeBytes(payload);
			wr.flush();
			wr.close();

			int responseCode = con.getResponseCode();
			System.out.println("nSending 'POST' request to URL : " + url);
			LOGGER.debug("nSending 'POST' request to URL : " + url);
			System.out.println("Post Data : " + payload);
			LOGGER.debug("Post Data : " + payload);
			System.out.println("Response Code : " + responseCode);
			LOGGER.debug("Response Code : " + responseCode);

			BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
			String output;
			StringBuffer response = new StringBuffer();

			while ((output = in.readLine()) != null) {
				response.append(output);
			}
			in.close();

			// printing result from response
			System.out.println(response.toString());
			LOGGER.debug(response.toString());
		} catch (IOException e) {
			System.err.println(e.getMessage());
			LOGGER.error(e.getMessage());
		}
	}
}
