/**
 * 
 */
package gov.va.genisis2.util.ldap;

import gov.va.genisis2.model.LDAPLogger;
import gov.va.genisis2.model.LDAPUser;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * @author 586338
 *
 */
//@Component
public class Transformer {

	public LDAPLogger getUser(Map<String, String> userObject,
			Map<String, String> managerObject) {
		LDAPLogger ldapLogger = new LDAPLogger();

		if (userObject !=null) {
			ldapLogger.setRole(userObject.get("role"));
			ldapLogger.setFirstName(userObject.get("givenName"));
			ldapLogger.setLastName(userObject.get("sn"));
			ldapLogger.setEmail(userObject.get("mail"));
			ldapLogger.setId(userObject.get("uid"));
		}

		
		if (managerObject !=null) {
			LDAPUser managerDTO = new LDAPUser();
		managerDTO.setFirstName(managerObject.get("givenName"));
		managerDTO.setLastName(managerObject.get("sn"));
		managerDTO.setEmail(managerObject.get("mail"));
		managerDTO.setId(managerObject.get("uid"));
		managerDTO.setRole(managerObject.get("role"));
		ldapLogger.setDatamanager(managerDTO);
		//lggerDTO.setManagerDTO(managerDTO);
		}

		return ldapLogger;
	}

	public Map<String, String> getLdapKeyValuePairs(String list,
			Map<String, String> out) {
		String json = list;
		JSONArray jsonArray = new JSONArray(json);
		for (int i = 0; i < jsonArray.length(); i++) {
			JSONObject tt = jsonArray.getJSONObject(i);
			out = parseList(tt, out);
		}

		return out;
	}

	public static String getRoleApprover(String o, String key) {
		String str = StringUtils.EMPTY;
		if (StringUtils.isNotEmpty(o)) {
			String[] parts = o.split(",");
			for (int i = 0; i < parts.length; i++) {
				if (StringUtils.contains(parts[i], key)) {
					String[] out = parts[i].split("=");
					str = out[1];
					break;
				}
			}
		}

		return str;
	}

	private Map<String, String> parseList(JSONObject json,
			Map<String, String> out) throws JSONException {
		Iterator<String> keys = json.keys();
		while (keys.hasNext()) {
			String key = keys.next();
			String val = null;
			try {

				if (!StringUtils.equalsIgnoreCase(key, "userPassword")) {
					JSONObject value = json.getJSONObject(key);
					parseList(value, out);
				}
			} catch (Exception e) {
				val = json.getString(key);
			}

			if (val != null) {
				out.put(key, val);
			}
		}
		return out;
	}

}
