package gov.va.genisis2.service.impl;

import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.service.IStudyApprovalService;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author 586338
 *
 */
@Service
public class StudyApprovalService implements IStudyApprovalService {

	@Autowired
	private IStudyApprovalDao studyApprovalDao;

	public IStudyApprovalDao getStudyApprovalDao() {
		return studyApprovalDao;
	}

	public void setStudyApprovalDao(IStudyApprovalDao studyApprovalDao) {
		this.studyApprovalDao = studyApprovalDao;
	}

	public int createStudyApproval(
			StudyApproval studyApproval) {
		return studyApprovalDao.createStudyApproval(studyApproval);
	}
	
	public int updateStudyApproval(StudyApproval studyApproval) {
		return studyApprovalDao.updateStudyApproval(studyApproval);
	}

	public StudyApproval getStudyApprovalsByID(int id) {
		return studyApprovalDao.getStudyApprovalsByID(id);
	}

	public List<StudyApproval> getStudyApprovalsByUID(String uid) {
		return studyApprovalDao.getStudyApprovalsByUID(uid);
	}

	public List<StudyApproval> getStudyApprovals() {
		return studyApprovalDao.getStudyApprovals();
	}

}
