package gov.va.genisis2.service.impl;

import gov.va.genisis2.dao.IRequestDao;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestHistory;

import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.service.IRequestService;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
/**
 * @author 586338
 *
 */
@Service
public class RequestService implements IRequestService {

	@Autowired
	private IRequestDao requestDao;

	public IRequestDao getRequestDao() {
		return requestDao;
	}

	public void setRequestDao(IRequestDao requestDao) {
		this.requestDao = requestDao;
	}

	public int createRequest(Request request) {
		return requestDao.createRequest(request);
	}

	public List<Request> getRequestsByUID(String uid) {
		return requestDao.getRequestsByUID(uid);
	}

	public Request getRequestsById(int id) {
		return requestDao.getRequestsById(id);
	}

	public List<Request> getAllRequests() {
		return requestDao.getAllRequests();
	}

	public List<Request> getAllRequestsByStudyApproval(int studyApprovalId) {
		return requestDao.getAllRequestsByStudyApproval(studyApprovalId);
	}
	
	public List<Request> getAllRequestsByCommentHistory(int commentHistoryId) {
		return requestDao.getAllRequestsByCommentHistory(commentHistoryId);
	}
	
	public List<Request> getAllRequestsByStaus(String status) {
		return requestDao.getAllRequestsByStaus(status);
	}

	public int submitOrModify(Request request) {
		return requestDao.submitOrModify(request);
	}

	
	public RequestType getRequestType(int id) {

		return requestDao.getRequestType(id);
	}

	public Source getSource(int id) {
		return requestDao.getSource(id);
	}

	
	public int submitOrModify(RequestHistory requestHistory) {
		return requestDao.submitOrModify(requestHistory);
	}

	
	public List<RequestHistory> getRequestHistoryById(int requestId) {
	  return requestDao.getRequestHistoryById(requestId);
	}

	
	public List<Source> getDataSources() {
		return requestDao.getDataSources();
	}

	public List<RequestType> getRequestTypes() {
		return requestDao.getRequestTypes();
	}

}
