package gov.va.genisis2.service.impl;

import gov.va.genisis2.dao.ICommentHistoryDao;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.service.ICommentHistoryService;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author 586338
 *
 */
@Service
public class CommentHistoryService implements ICommentHistoryService {

	@Autowired
	private ICommentHistoryDao commentHistoryDao;

	public ICommentHistoryDao getCommentHistoryDao() {
		return commentHistoryDao;
	}

	public void setCommentHistoryDao(ICommentHistoryDao commentHistoryDao) {
		this.commentHistoryDao = commentHistoryDao;
	}

	public int createCommentHistory(
			CommentHistory commentHistory) {
		return commentHistoryDao.createCommentHistory(commentHistory);
	}
	
	public int updateCommentHistory(CommentHistory commentHistory) {
		return commentHistoryDao.updateCommentHistory(commentHistory);
	}

	public CommentHistory getCommentHistoriesByID(int id) {
		return commentHistoryDao.getCommentHistoriesByID(id);
	}

	public List<CommentHistory> getCommentHistoriesByUID(String uid) {
		return commentHistoryDao.getCommentHistoriesByUID(uid);
	}

	public List<CommentHistory> getCommentHistories() {
		return commentHistoryDao.getCommentHistories();
	}

	
	
	
	

	public int submitOrModify(CommentHistory commentHistory) {
		
		return commentHistoryDao.submitOrModify(commentHistory);
	}


	public List<CommentHistory> getCommentHistoryById(int requestId) {
		return commentHistoryDao.getCommentHistoryById(requestId);
	}

	
	public CommentHistory getCommentHistoryByCommentId(int commentId) {
	
		return commentHistoryDao.getCommentHistoryByCommentId(commentId);
	}

	@Override
	public List<CommentHistory> getCommentHistoryByRequestIdStatusId(
			int requestId,  String taskId) {
		
		return commentHistoryDao.getCommentHistoryByRequestIdStatusId(requestId, taskId);
	}

}
