package gov.va.genisis2.model;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;


@Entity
@Table(name="WorkflowStatus"
    ,schema="dbo"
)
public class WorkflowStatus  implements java.io.Serializable {


     private int id;
     private String description;
     private Set<CommentHistory> commentHistories = new HashSet<CommentHistory>(0);

    public WorkflowStatus() {
    }

	
    public WorkflowStatus(int id) {
        this.id = id;
    }
    public WorkflowStatus(int id, String description, Set<CommentHistory> commentHistories) {
       this.id = id;
       this.description = description;
       this.commentHistories = commentHistories;
    }
   
     @Id 

    
    @Column(name="Id", unique=true, nullable=false)
    public int getId() {
        return this.id;
    }
    
    public void setId(int id) {
        this.id = id;
    }

    
    @Column(name="Description", length=50)
    public String getDescription() {
        return this.description;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

@OneToMany(fetch=FetchType.LAZY, mappedBy="workflowStatus")
    public Set<CommentHistory> getCommentHistories() {
        return this.commentHistories;
    }
    
    public void setCommentHistories(Set<CommentHistory> commentHistories) {
        this.commentHistories = commentHistories;
    }

}
