package gov.va.genisis2.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;


@Entity
@Table(name="RequestHistory"
    ,schema="dbo"
   
)
@JsonIgnoreProperties({"request"})
public class RequestHistory  implements java.io.Serializable {


     private int histLineNo;
     private Request request;
     private int processId;
     private String title;
     private String description;
     private String approvalStatus;
   
     private String detailesInternalStatusCode;
     private String statusDescription;
     private int requestType;
     private int source;
     private Byte notifyCollaboraters;
     private Integer associatedRequest1;
     private Integer associatedRequest2;
     private Integer associatedRequest3;
     private int studyApproval;
     private Date createdOn;
     private Date modifiedOn;
     private String createdBy;
     private String modifiedBy;
     private String approverId;
     private String taskId;

    public RequestHistory() {
    }

	
    public RequestHistory(int histLineNo, Request request, int processId, int requestType, int source, int studyApproval) {
        this.histLineNo = histLineNo;
        this.request = request;
        this.processId = processId;
        this.requestType = requestType;
        this.source = source;
        this.studyApproval = studyApproval;
    }

	public RequestHistory(int histLineNo, Request request, int processId,
			String title, String description, String approvalStatus,
			String detailesInternalStatusCode, String statusDescription,
			int requestType, int source, Byte notifyCollaboraters,
			Integer associatedRequest1, Integer associatedRequest2,
			Integer associatedRequest3, int studyApproval, Date createdOn,
			Date modifiedOn, String createdBy, String modifiedBy,
			String approverId, String taskId) {
		this.histLineNo = histLineNo;
		this.request = request;
		this.processId = processId;
		this.title = title;
		this.description = description;
		this.approvalStatus = approvalStatus;
		this.taskId = taskId;
		this.detailesInternalStatusCode = detailesInternalStatusCode;
		this.statusDescription = statusDescription;
		this.requestType = requestType;
		this.source = source;
		this.notifyCollaboraters = notifyCollaboraters;
		this.associatedRequest1 = associatedRequest1;
		this.associatedRequest2 = associatedRequest2;
		this.associatedRequest3 = associatedRequest3;
		this.studyApproval = studyApproval;
		this.createdOn = createdOn;
		this.modifiedOn = modifiedOn;
		this.createdBy = createdBy;
		this.modifiedBy = modifiedBy;
		this.approverId = approverId;
	}

     @Id 
    @Column(name="HistLineNo", unique=true, nullable=false)
    public int getHistLineNo() {
        return this.histLineNo;
    }
    
    public void setHistLineNo(int histLineNo) {
        this.histLineNo = histLineNo;
    }

@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="Id", nullable=false)
    public Request getRequest() {
        return this.request;
    }
    
    public void setRequest(Request request) {
        this.request = request;
    }

    
    @Column(name="ProcessId", nullable=false)
    public int getProcessId() {
        return this.processId;
    }
    
    public void setProcessId(int processId) {
        this.processId = processId;
    }

    
    @Column(name="Title", length=256)
    public String getTitle() {
        return this.title;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }

    
    @Column(name="Description", length=3000)
    public String getDescription() {
        return this.description;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

    
    @Column(name="ApprovalStatus", length=50)
    public String getApprovalStatus() {
        return this.approvalStatus;
    }
    
    public void setApprovalStatus(String approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    
     
    @Column(name="DetailesInternalStatusCode", length=50)
    public String getDetailesInternalStatusCode() {
        return this.detailesInternalStatusCode;
    }
    
    public void setDetailesInternalStatusCode(String detailesInternalStatusCode) {
        this.detailesInternalStatusCode = detailesInternalStatusCode;
    }

    
    @Column(name="StatusDescription", length=50)
    public String getStatusDescription() {
        return this.statusDescription;
    }
    
    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    
    @Column(name="RequestType", nullable=false)
    public int getRequestType() {
        return this.requestType;
    }
    
    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    
    @Column(name="Source", nullable=false)
    public int getSource() {
        return this.source;
    }
    
    public void setSource(int source) {
        this.source = source;
    }

    
    @Column(name="NotifyCollaboraters")
    public Byte getNotifyCollaboraters() {
        return this.notifyCollaboraters;
    }
    
    public void setNotifyCollaboraters(Byte notifyCollaboraters) {
        this.notifyCollaboraters = notifyCollaboraters;
    }

    
    @Column(name="AssociatedRequest1")
    public Integer getAssociatedRequest1() {
        return this.associatedRequest1;
    }
    
    public void setAssociatedRequest1(Integer associatedRequest1) {
        this.associatedRequest1 = associatedRequest1;
    }

    
    @Column(name="AssociatedRequest2")
    public Integer getAssociatedRequest2() {
        return this.associatedRequest2;
    }
    
    public void setAssociatedRequest2(Integer associatedRequest2) {
        this.associatedRequest2 = associatedRequest2;
    }

    
    @Column(name="AssociatedRequest3")
    public Integer getAssociatedRequest3() {
        return this.associatedRequest3;
    }
    
    public void setAssociatedRequest3(Integer associatedRequest3) {
        this.associatedRequest3 = associatedRequest3;
    }

    
    @Column(name="StudyApproval", nullable=false)
    public int getStudyApproval() {
        return this.studyApproval;
    }
    
    public void setStudyApproval(int studyApproval) {
        this.studyApproval = studyApproval;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="CreatedOn", length=23)
    public Date getCreatedOn() {
        return this.createdOn;
    }
    
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="ModifiedOn", length=23)
    public Date getModifiedOn() {
        return this.modifiedOn;
    }
    
    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    
    @Column(name="CreatedBy", length=50)
    public String getCreatedBy() {
        return this.createdBy;
    }
    
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    
    @Column(name="ModifiedBy", length=50)
    public String getModifiedBy() {
        return this.modifiedBy;
    }
    
    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    
    @Column(name="ApproverId", length=50)
    public String getApproverId() {
        return this.approverId;
    }
    
    public void setApproverId(String approverId) {
        this.approverId = approverId;
    }

    @Column(name="TaskId", length=50)
    public String getTaskId() {
        return this.taskId;
    }
    
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    
}


