/**
 * 
 */
package gov.va.genisis2.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import org.hibernate.annotations.CreationTimestamp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@Entity
@Table(name="CommentHistory"
    ,schema="dbo"
 )
@JsonIgnoreProperties({"request","workflowStatus","commentId","taskId"})
public class CommentHistory  implements java.io.Serializable {


     private int commentId;
     private Request request;
     private WorkflowStatus workflowStatus;
     private String comments;
     private Date createdOn;
     private String createdBy;
     private int requestId;
     private String status;
     private String type;
     private String taskId;
     

    public CommentHistory() {
    }

	
    public CommentHistory(int commentId, Request request, WorkflowStatus workflowStatus) {
        this.commentId = commentId;
        this.request = request;
        this.workflowStatus = workflowStatus;
    }
    public CommentHistory(int commentId, Request request, WorkflowStatus workflowStatus, String comment, Date createdOn, String createdBy,String taskId ) {
       this.commentId = commentId;
       this.request = request;
       this.workflowStatus = workflowStatus;
       this.comments = comments;
       this.createdOn = createdOn;
       this.createdBy = createdBy;
       this.taskId = taskId;
    }
   
     @Id 

    
    @Column(name="CommentId", unique=true, nullable=false)
    public int getCommentId() {
        return this.commentId;
    }
    
    public void setCommentId(int commentId) {
        this.commentId = commentId;
    }

@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RequestId", nullable=false)
    public Request getRequest() {
        return this.request;
    }
    
    public void setRequest(Request request) {
        this.request = request;
    }

@ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="StatusId", nullable=false)
    public WorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }
    
    public void setWorkflowStatus(WorkflowStatus workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    
    @Column(name="Comments", length=3000)
    public String getComments() {
        return this.comments;
    }
    
    public void setComments(String comment) {
        this.comments = comment;
    }

    @CreationTimestamp
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="CreatedOn", length=23)
    public Date getCreatedOn() {
        return this.createdOn;
    }
    
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    
    @Column(name="CreatedBy", length=50)
    public String getCreatedBy() {
        return this.createdBy;
    }
    
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Transient
	public int getRequestId() {
		return requestId;
	}


	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	@Transient
	public String getStatus() {
		return status;
	}


	public void setStatus(String status) {
		this.status = status;
	}

	@Column(name="Type", length=6)
	public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}


	  @Column(name="TaskId", length=50)
	    public String getTaskId() {
	        return this.taskId;
	    }
	    
	    public void setTaskId(String taskId) {
	        this.taskId = taskId;
	    }


		@Override
		public String toString() {
			return "CommentHistory [commentId=" + commentId + ", request="
					+ request + ", workflowStatus=" + workflowStatus
					+ ", comments=" + comments + ", createdOn=" + createdOn
					+ ", createdBy=" + createdBy + ", requestId=" + requestId
					+ ", status=" + status + ", type=" + type + ", taskId="
					+ taskId + "]";
		}

	    
	    
}


