package gov.va.genisis2.dao.impl;

import gov.va.genisis2.dao.ILookUpDao;
import gov.va.genisis2.model.WorkflowStatus;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value = "transactionManager")
public class LookUpDao implements ILookUpDao {

	private final org.slf4j.Logger Logger = LoggerFactory
			.getLogger(LookUpDao.class);

	@Autowired
	@Qualifier("hibernateTemplate")
	private HibernateTemplate hibernateTemplate;

	public HibernateTemplate getHibernateTemplate() {
		return hibernateTemplate;
	}

	@Autowired
	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	@Override
	public int getStatusId(String statusDescription) {
		int statusId = 0;
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<WorkflowStatus> query = criteriaBuilder
				.createQuery(WorkflowStatus.class);
		Root<WorkflowStatus> root = query.from(WorkflowStatus.class);
		Predicate condition = criteriaBuilder.equal(root.get("description"),
				statusDescription);
		query.where(condition);
		List<WorkflowStatus> requestList = entityManager.createQuery(query)
				.getResultList();
		if (requestList != null && requestList.size() > 0) {
			statusId = requestList.get(0).getId();
		}

		return statusId;
	}

}
