package gov.va.genisis2.dao.impl;

import java.util.List;

import gov.va.genisis2.dao.ILdapDao;
import gov.va.genisis2.util.ldap.UserAttributeMapperJSON;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;


/**
 * @author 586338
 *
 */
@Repository
//@Transactional
public class LdapDao implements ILdapDao {

	private LdapTemplate ldapTemplate;

	public LdapTemplate getLdapTemplate() {
		return ldapTemplate;
	}

	@Autowired
	public void setLdapTemplate(LdapTemplate ldapTemplate) {
		this.ldapTemplate = ldapTemplate;
	}

	public String getUserDetails(String mail) {
		AndFilter andFilter = new AndFilter();
		andFilter.and(new EqualsFilter("mail", mail));

	List<String> lst=  ldapTemplate.search("", andFilter.encode(),
				new UserAttributeMapperJSON());
		return lst.toString();
		
	}


	public String getUserDetails(String key, String value) {
		AndFilter andFilter = new AndFilter();
		andFilter.and(new EqualsFilter(key, value));

		List<String>  lst=ldapTemplate.search("", andFilter.encode(),
				new UserAttributeMapperJSON());
		return lst.toString();
	}
}
