/**
 * 
 */
package gov.va.genisis2.dao.impl;

import gov.va.genisis2.dao.ICommentHistoryDao;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.RequestHistory;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;

import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.sun.media.jfxmedia.logging.Logger;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.query.Query;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate5.HibernateTemplate;


@Repository
@Transactional(value="transactionManager")
public class CommentHistoryDao implements ICommentHistoryDao {
	
	private final org.slf4j.Logger Logger = LoggerFactory
			.getLogger(CommentHistoryDao.class);

	

	private HibernateTemplate hibernateTemplate;

	public HibernateTemplate getHibernateTemplate() {
		return hibernateTemplate;
	}

	@Autowired
	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	public int createCommentHistory(CommentHistory entity) {
		int id = 0;
		if (entity != null )
			entity.setCommentId(this.maxRowValue());
		
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		EntityTransaction transaction = null;
		try {
			transaction = entityManager.getTransaction();
			transaction.begin();
			entityManager.persist(entity);
			transaction.commit();
			id = entity.getCommentId();
		} catch (RuntimeException e) {
			if (transaction != null)
				transaction.rollback();
		} finally {
			entityManager.close();
		}
		return id;
	}
	
	public int updateCommentHistory(CommentHistory entity) {
		hibernateTemplate.saveOrUpdate(entity);
		return entity.getCommentId();
	}

	public CommentHistory getCommentHistoriesByID(int id) {
		CommentHistory CommentHistory = (CommentHistory) hibernateTemplate.get(
				CommentHistory.class, id);
		return CommentHistory;
	}

	public List<CommentHistory> getCommentHistoriesByUID(String uid) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<CommentHistory> query = criteriaBuilder
				.createQuery(CommentHistory.class);
		Root<CommentHistory> root = query.from(CommentHistory.class);
		query.where(criteriaBuilder.equal(root.get("createdBy"), uid));
		query.select(root);
		List<CommentHistory> CommentHistoryList = entityManager
				.createQuery(query).getResultList();
		return CommentHistoryList;
	}

	public List<CommentHistory> getCommentHistories() {
		List<CommentHistory> CommentHistoryList = (List<CommentHistory>) hibernateTemplate
				.find("from CommentHistory");
		return CommentHistoryList;
	}
	
	@SuppressWarnings("unchecked")
	private int maxRowValue() {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery criteriaQuery = criteriaBuilder
				.createQuery(CommentHistory.class);
		Root root = criteriaQuery.from(CommentHistory.class);
		criteriaQuery.select(criteriaBuilder.max(root.get("id")));
		Query query = (Query) entityManager.createQuery(criteriaQuery);
		Integer result = (Integer) query.getSingleResult();
		return result.intValue() +1 ;
	}

	
	
	// Param's stuff begins
	
	
	public int submitOrModify(CommentHistory entity) {
		int maxRowCommentHistory = 0;
		maxRowCommentHistory = maxRowValueCommentHistory();
		entity.setCommentId(maxRowCommentHistory);
		hibernateTemplate.saveOrUpdate(entity);
		return entity.getCommentId();
	}

	
	public List<CommentHistory> getCommentHistoryById(int requestId) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder builder = entityManager.getCriteriaBuilder();
		CriteriaQuery<CommentHistory> criteria = builder
				.createQuery(CommentHistory.class);
		Root<CommentHistory> org = criteria.from(CommentHistory.class);
		criteria.select(org);
		criteria.where(builder.and(builder.equal(org.get("request").get("id"),
				requestId)));
		criteria.orderBy(builder.desc(org.get("createdOn")));
		List<CommentHistory> historytList = entityManager.createQuery(criteria)
				.getResultList();
		return historytList;
	}


	public CommentHistory getCommentHistoryByCommentId(int commentId) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder builder = entityManager.getCriteriaBuilder();
		CriteriaQuery<CommentHistory> criteria = builder
				.createQuery(CommentHistory.class);
		Root<CommentHistory> org = criteria.from(CommentHistory.class);
		criteria.select(org);
		criteria.where(builder.and(builder.equal(org.get("commentId"),
				commentId)));
		criteria.orderBy(builder.desc(org.get("createdOn")));
		CommentHistory commentHistory = entityManager.createQuery(criteria).getSingleResult();
		return commentHistory;
	}


	public List<CommentHistory> getCommentHistoryByRequestIdStatusId(
			int requestId,  String taskId) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder builder = entityManager.getCriteriaBuilder();
		CriteriaQuery<CommentHistory> criteria = builder
				.createQuery(CommentHistory.class);
		Root<CommentHistory> org = criteria.from(CommentHistory.class);

		Predicate condition1 = builder.equal(org.get("request").get("id"),
				requestId);
		
		Predicate condition2 = builder.equal(org.get("taskId"), taskId);
		Predicate conditions = builder.and(condition1,  condition2);
		criteria.where(conditions);
		List<CommentHistory> result = null;
		Query query = (Query) entityManager.createQuery(criteria);
		try {
			result = query.getResultList();
		} catch (NoResultException e) {
			Logger.error("Request Id : " + requestId
					+ "  Error occured while generating CommentHistory ");
		}
		return result;
	}
	
	private int maxRowValueCommentHistory() {
		int maxRowVal = 1;
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery criteriaQuery = criteriaBuilder
				.createQuery(CommentHistory.class);
		Root root = criteriaQuery.from(CommentHistory.class);
		criteriaQuery.select(criteriaBuilder.max(root.get("commentId")));
		Query query = (Query) entityManager.createQuery(criteriaQuery);
		Integer result = (Integer) query.getSingleResult();

		if (result != null) {
			maxRowVal = result.intValue() + 1;
		}
		return maxRowVal;
	}

	

}