/**
 * 
 */
package gov.va.genisis2.bo;

import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/**
 * The Class BusinessHelper.
 */
public final class  BusinessHelper {

	/**
	 * Gets the todays date.
	 *
	 * @return the todays date
	 */
	public static Timestamp getTodaysDate() {
		Calendar cal = Calendar.getInstance();
		java.sql.Timestamp timestamp = new java.sql.Timestamp(
				cal.getTimeInMillis());
		return timestamp;
	}
	
	/**
	 * Gets the formatted date.
	 *
	 * @param date the date
	 * @return the formatted date
	 */
	public static DateTimeFormatter getFormattedDate(Date date) {
		String dateTime = date.toString();
		DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern("MM/dd/yyyy HH:mm:ss");
		DateTime jodatime = dateTimeFormatter.parseDateTime(dateTime);
		DateTimeFormatter dateTimeFormatOutDate = DateTimeFormat.forPattern("MM/dd/yyyy");
		System.out.println(dateTimeFormatOutDate.print(jodatime));
		return dateTimeFormatOutDate;
	}

	/**
	 * Handle request payload.
	 *
	 * @param request the request
	 * @return the request
	 */
	public static Request handleRequestPayload(Request request) {

		if (request != null) {
			boolean varNotifyBoolean = request.isNotify();
			byte varNotify = (byte) (varNotifyBoolean ? 1 : 0);
			request.setNotifyCollaboraters(varNotify);
			request.setProcessId(0);
			request.setStatusDescription("Draft");
			
			if (request.getAssociatedRequests() != null) {

				List<Integer> lst = request.getAssociatedRequests();
				for (Integer element : lst) {
					if (lst.indexOf(element) == 0)
						request.setAssociatedRequest1(element);
					else if (lst.indexOf(element) == 1)
						request.setAssociatedRequest2(element);
					else if (lst.indexOf(element) == 2)
						request.setAssociatedRequest3(element);
				}
			}
			request.setCreatedOn(getTodaysDate());
			request.setRequestType(request.getType());
		}
		return request;
	}
	
	/**
	 * Handle study approval payload.
	 *
	 * @param studyApproval the study approval
	 * @return the study approval
	 */
	public static StudyApproval handleStudyApprovalPayload(
			StudyApproval studyApproval) {
		if (studyApproval != null) {
			List<Integer> lst = studyApproval.getAssociatedApprovals();
			for (Integer study : lst) {
				if (lst.indexOf(study) == 0)
					studyApproval.setAssociatedStudyApproval1(study);
				else if (lst.indexOf(study) == 1)
					studyApproval.setAssociatedStudyApproval2(study);
				else if (lst.indexOf(study) == 2)
					studyApproval.setAssociatedStudyApproval3(study);
			}
			studyApproval.setCreatedOn(getTodaysDate());
			studyApproval.setProcessId(999999999);
			studyApproval.setApprovalIdObtained(studyApproval.getObtained());
		}
		return studyApproval;
	}
	/**
	 * Handle comment history payload.
	 *
	 * @param commentHistory the comment history
	 * @return the comment history
	 */
	public static CommentHistory handleCommentHistoryPayload(CommentHistory commentHistory) {
		
		return commentHistory;
	}
	
	/**
	 * Prepare study approval response payload.
	 *
	 * @param studyApprovalList the study approval list
	 * @return the list
	 */
	public static  List<StudyApproval> prepareStudyApprovalResponsePayload(List<StudyApproval> studyApprovalList) {
		
		if (studyApprovalList == null || studyApprovalList.size() == 0)
			return Collections.EMPTY_LIST;

		List<Integer> associatedStudyApprovals = null;

		for (StudyApproval studyApproval : studyApprovalList) {
			int memeberId = studyApprovalList.indexOf(studyApproval);
			associatedStudyApprovals = new ArrayList<Integer>();
			if (studyApproval.getAssociatedStudyApproval1() != null)
				associatedStudyApprovals.add(studyApproval
						.getAssociatedStudyApproval1());
			if (studyApproval.getAssociatedStudyApproval2() != null)
				associatedStudyApprovals.add(studyApproval
						.getAssociatedStudyApproval2());
			if (studyApproval.getAssociatedStudyApproval3() != null)
				associatedStudyApprovals.add(studyApproval
						.getAssociatedStudyApproval3());

			studyApprovalList.get(memeberId).setAssociatedApprovals(
					associatedStudyApprovals);
			studyApprovalList.get(memeberId).setObtained(studyApproval.getApprovalIdObtained());
		}
		return studyApprovalList;
	}
	
	/**
     * Prepare comment history response payload.
     *
     * @param commentHistoryList the comment history list
     * @return the list
     */
    public static  List<CommentHistory> prepareCommentHistoryResponsePayload(List<CommentHistory> commentHistoryList) {
		
		if (commentHistoryList == null || commentHistoryList.size() == 0)
			return Collections.EMPTY_LIST;

		
		return commentHistoryList;
	}	
	/**
	 * Prepare request response payload.
	 *
	 * @param requestList the request list
	 * @return the list
	 */
	public static List<Request> prepareRequestResponsePayload(List<Request> requestList) {

		if (requestList == null || requestList.size() == 0)
			return Collections.EMPTY_LIST;

		List<Request> listrequest = new ArrayList<Request>();
		List<Integer> associatedRequests = null;

		for (Request request : requestList) {
			int memeberId = requestList.indexOf(request);
			associatedRequests = new ArrayList<Integer>();
			
			if (request.getNotifyCollaboraters() !=null) {
			byte varNotify = request.getNotifyCollaboraters();
			if (varNotify != 0)
				requestList.get(memeberId).setNotify(true);
			else
				requestList.get(memeberId).setNotify(false);
			
			}

			if (request.getAssociatedRequest1() != null) {
				associatedRequests.add(request.getAssociatedRequest1());
			}
			if (request.getAssociatedRequest2() != null) {
				associatedRequests.add(request.getAssociatedRequest2());
			}
			if (request.getAssociatedRequest3() != null) {
				associatedRequests.add(request.getAssociatedRequest3());
			}
			requestList.get(memeberId)
					.setAssociatedRequests(associatedRequests);
			requestList.get(memeberId).setType(request.getRequestType());
			//requestList.get(memeberId).setReason(request.getComments());
			requestList.get(memeberId).setComments(request.getComments());
		}
		return requestList;
	}
}
