package gov.va.genisis2.bo;

import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
public class ActivitiService {
	private final static org.slf4j.Logger Logger = LoggerFactory
			.getLogger(ActivitiService.class);

	
	private ProcessEngine processEngine;

	
	public ProcessEngine getProcessEngine() {
		return processEngine;
	}
    @Autowired
	public void setProcessEngine(ProcessEngine processEngine) {
		this.processEngine = processEngine;
	}

	public String startProcess(String userId) throws Exception {
		Logger.info("Start workflow process");
		/*
		 * Deploy the process
		 */

		final RepositoryService repositoryService = processEngine
				.getRepositoryService();

		repositoryService.createDeployment().enableDuplicateFiltering()
				.addClasspathResource("Genisis2WorkFlowProcess.bpmn").deploy();

		// final RuntimeService runtimeService =
		// processEngine.getRuntimeService();
		final RuntimeService runtimeService = processEngine.getRuntimeService();

		Map<String, Object> variableMap = new HashMap<String, Object>();
		variableMap.put("processStartedBy", userId);
		ProcessInstance processInstance = runtimeService
				.startProcessInstanceByKey("Genisis2WorkFlowProcess",
						variableMap);
		String processId = processInstance.getId();
		return processId;
	}
	
	public String getprocessTaskId(String processId, String userId)
			throws Exception {
		String taskId = StringUtils.EMPTY;

		TaskService taskService = processEngine.getTaskService();
		List<Task> tasks = taskService.createTaskQuery().taskAssignee(userId)
				.processInstanceId(processId).list();
		for (Task task : tasks) {
			taskId = task.getId();
			break;
		}
		return taskId;
	}

	public void claimAndCompleteHumanTask(String processId, String userId,
			Request request, JSONObject json) throws Exception {
		
		
		Logger.info("Claim and Complete Human Task");
		if (StringUtils.isBlank(processId)) {
			Logger.info("Process ID is null, unable to claim and complete Task");
		} else {

			// TaskService taskService = processEngine.getTaskService();
			TaskService taskService = processEngine.getTaskService();

			List<Task> tasks = taskService.createTaskQuery()
					.taskAssignee(userId).processInstanceId(processId).list();

			String requestorId = (String) json.get("requestorId");
			String approverDecision = (String) json.get("approverDecision");
			String approverId = (String) json.get("approverId");
			String from_user = (String) json.get("from_user");
			String to_user = (String) json.get("to_user");
			String cc_users = (String) json.get("cc_users");
			String fulfillmentDecision = (String) json
					.get("fulfillmentDecision");
			String resultAcceptanceDecision = (String) json
					.get("resultAcceptanceDecision");

			RequestType requestType = null;
			Source source = null;
			if (StringUtils.equals("Sent", request.getStatusDescription())) {
				requestType = (RequestType) json.get("requestType");
				source = (Source) json.get("source");
			}

			for (Task task : tasks) {
				Logger.info("Claiming  Task: " + task.getId() + " for user:" +userId);
				taskService.claim(task.getId(), userId);
				Map<String, Object> variableMap = new HashMap<String, Object>();
				variableMap.put("HumanTaskCompletedBy", userId);
				variableMap.put("request", request);

				variableMap.put("requestorId", requestorId);
				variableMap.put("approverDecision", approverDecision);
				variableMap.put("fulfillmentDecision", fulfillmentDecision);
				variableMap.put("resultAcceptanceDecision",
						resultAcceptanceDecision);

				variableMap.put("approverId", approverId);
				variableMap.put("from_user", from_user);
				variableMap.put("to_user", to_user);
				variableMap.put("cc_users", cc_users);

				variableMap.put("source", source);
				variableMap.put("requestType", requestType);

				taskService.complete(task.getId(), variableMap);
				Logger.info("Completed Task");
				break;
			}
		}
		
	}

	@Bean
	public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
		return new PropertySourcesPlaceholderConfigurer();
	}
}
