
USE GENISIS_DB
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO


CREATE TABLE [dbo].[RequestType](
	[Id] [int]  NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_RequestType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO


CREATE TABLE [dbo].[Source](
	[Id] [int]  NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_Source] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[StudyApproval](
	[Id] [int]  NOT NULL,
	[ProcessId] [int] NOT NULL,
	[ApprovalIdObtained] [varchar](3000) NULL,
	[AssociatedStudyApproval1] [int] NULL,
	[AssociatedStudyApproval2] [int] NULL,
	[AssociatedStudyApproval3] [int] NULL,
	[Title] [varchar](50) NULL,
	[Description] [varchar](3000) NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
 CONSTRAINT [PK_StudyApproval] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO


CREATE TABLE [dbo].[Request](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ProcessId] [int] NOT NULL,
	[Title] [varchar](256) NULL,
	[Description] [varchar](3000) NULL,
	[ApprovalStatus] [varchar](50) NULL,
	[Comments] [varchar](3000) NULL,
	[DetailesInternalStatusCode] [varchar](50) NULL,
	[StatusDescription] [varchar](50) NULL,
	[RequestType] [int] NOT NULL,
	[Source] [int] NOT NULL,
	[NotifyCollaboraters] [tinyint] NULL,
	[AssociatedRequest1] [int] NULL,
	[AssociatedRequest2] [int] NULL,
	[AssociatedRequest3] [int] NULL,
	[StudyApproval] [int] NOT NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
	[ApproverId] [varchar](50) NULL,
 CONSTRAINT [PK_Request] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO






