package tableCopy;
import java.awt.*;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.JFrame;
public class tableCopy {

    public static void main(String[] args) {
    	//create a new table copy frame
        new tableCopy();
    }

    public tableCopy() {
    	// set up frame for prototype
        EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                } catch (Exception ex) {
                }

                JFrame frame = new JFrame("Test");
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                //add pane that users will see and use
                frame.add(new LoginPane());
                frame.setPreferredSize(new Dimension(1500,1000));
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    @SuppressWarnings("serial")
    //where the pane that users will see will be instantiated
	public class LoginPane extends JLabel implements ActionListener {
        public LoginPane() {
            try {
            	ImageIcon bg = new ImageIcon(ImageIO.read(getClass().getResource("/background.jpg")));
            	Image image = bg.getImage();
            	Image newimg =image.getScaledInstance(1500, 1000, java.awt.Image.SCALE_SMOOTH);
            	bg = new ImageIcon(newimg);
                setIcon(bg);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
            setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = GridBagConstraints.SOUTHWEST;
            gbc.weightx =1;
            gbc.weighty =1;
            // create a button to start the copy table window 
            JButton submit = new JButton();
            gbc.insets = new Insets(0, 85, 205, 0);
            gbc.anchor = GridBagConstraints.SOUTHWEST;
            submit.setBorder(BorderFactory.createEmptyBorder());
            submit.setActionCommand("Copy Table");
            submit.setContentAreaFilled(false);
            //assign image to the button
            try {
                Image button = ImageIO.read(getClass().getResource("/copyButton.jpg"));
                submit.setIcon(new ImageIcon(button));
              } catch (Exception ex) {
                System.out.println(ex);
              }
            submit.addActionListener(this);
            add(submit, gbc);

        }

		@Override
		//if the button is pressed create the copy table pop up window 
		public void actionPerformed(ActionEvent e) {
			  if ("Copy Table".equals(e.getActionCommand())) 
			  {	
				  //initialize text and password fields with test log in information 
			        JTextField sourceIP = new JTextField("IP         ");
			        JTextField sourceUsername = new JTextField("AI");
			        JPasswordField sourcePassword = new JPasswordField("AI");
			        JTextField destIP = new JTextField("IP         ");
			        JTextField destUsername = new JTextField("data_ops");
			        JPasswordField destPassword = new JPasswordField("genisis20!7");
			        JTextField tableNames = new JTextField();
			        int rows =10;
			        int columns=5;
			        //create the look of the pop-up with GridLayout
			        JPanel panel = new JPanel(new GridLayout(rows,columns));
			        panel.add(new JLabel("Source Database FQDN/IP Address"));
			        panel.add(sourceIP);
			        panel.add(new JLabel());
			        panel.add(new JLabel("Destination Database FQDN/IP Address"));
			        panel.add(destIP);
			        skipRow(panel,columns);
			        panel.add(new JLabel("SQL Login Username"));
			        panel.add(sourceUsername);
			        panel.add(new JLabel());
			        panel.add(new JLabel("SQL Login Username"));
			        panel.add(destUsername);
			        skipRow(panel,columns);
			        panel.add(new JLabel("Password"));
			        panel.add(sourcePassword);
			        panel.add(new JLabel());
			        panel.add(new JLabel("Password"));
			        panel.add(destPassword);
			        skipRow(panel,columns);
			        skipRow(panel,columns);
			        skipRow(panel,columns);
			        panel.add(new JLabel());
			        panel.add(new JLabel("                                                                Table Name(s)"));
			        panel.add(tableNames);
			        skipRow(panel,columns-1);
			        panel.add(new JLabel("(Enter one or more table names with commas separating them)"));
			        int result = JOptionPane.showConfirmDialog(null, panel, "Copy Table",
			            JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
			        if (result == JOptionPane.OK_OPTION)
			        	//when all the information is correct in the fields, press the default pop-up okay option
			        {
			        	//get the text input into the fields and initialize variables for parameterization
			        	 String sIP = sourceIP.getText();
			        	 //no longer needed due to use of Linked Servers
			        	 //String sUsername = sourceUsername.getText();
			        	 //char[] sPasswords = sourcePassword.getPassword();
			        	 //String sPassword = new String(sPasswords);
			        	 String dIP = destIP.getText();
			        	 String dUsername = destUsername.getText();
			        	 char[] dPasswords = destPassword.getPassword();
			        	 String dPassword = new String(dPasswords);
			        	 // get tables entered into the field as a string
			        	 String tables = tableNames.getText();
			        	 //convert table field string into string array splitting at commas
						  String[] table  = tables.split(",");
						  //remove trailing white spaces and error check for empty table field
						  for (int i = 0;i<table.length;i++)
						  {
							  if(table[0].equals(""))
								  
							  {
							 JOptionPane.showMessageDialog(null, "No Table(s) Found", "Error", JOptionPane.ERROR_MESSAGE);
							 JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
							 return;
							  }
								  
							 table[i] = table[i].trim();
							  System.out.println(table[i]);
						  }
						  // starting with the first table in the string array, use a for loop to run one table at a time through the parameterized copy process
						  for (int i = 0;i<table.length;i++){
							  //initialize different commands to be run  
						  String sourceTableCount_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i precount.sql -v ip = "+sIP+" tb = "+table[i];
						  String sourceChecksum_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i prechecksum.sql -v ip = "+sIP+" tb = "+table[i];
						  String tableCopy_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i tablecopy.sql -v ip = "+sIP+" tb = "+table[i];
						  String destTableCount_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i postcount.sql -v tb = "+table[i];
						  String destChecksum_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i postchecksum.sql -v tb = "+table[i];
						  String copyStatusUpdate_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i copyStatusUpdate.sql -v tb = "+table[i];
						  String managementInsert_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i managementInsert.sql -v tb = "+table[i];
						  String precopyStatusUpdate_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i beforeCopyError.sql";
						  String postcopyStatusUpdate_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i afterCopyError.sq";
						  String dropCorrupted_cmd ="sqlcmd -U "+dUsername+" -P "+dPassword+" -S "+dIP+" -d "+ "MANAGEMENT" +" -i dropCorrupted.sql -v tb = "+table[i];
						  try {
							  String line;
							  String inputLog = "";
							  String errorLog = "";
							  
							//insert the table name into the management table to create a row for logging while checking for errors thrown by sqlcmd
							  System.out.println("insert");
							  Process process = Runtime.getRuntime().exec(managementInsert_cmd);
							  int status = process.waitFor();
							  System.out.println(status); 
							  BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
									   while ((line = input.readLine()) != null) 
									   {
										  inputLog=inputLog+line+"\n";
									   }
									   input.close();
									   System.out.println(inputLog);
									   if(inputLog.toLowerCase().contains("Msg".toLowerCase()))
									   {
										        JOptionPane.showMessageDialog(null, inputLog, "Error", JOptionPane.ERROR_MESSAGE);
										        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
										        process = Runtime.getRuntime().exec(precopyStatusUpdate_cmd);
												  status = process.waitFor();
										        return;
									   }
									   System.out.println(inputLog);
									   BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
									   while ((line = error.readLine()) != null) 
									   {
										  errorLog=errorLog+line+"\n";
									   }
									   error.close();
									   System.out.println(errorLog);
									   if(errorLog.toLowerCase().contains("error".toLowerCase()))
									   {
										        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
										        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
										        process = Runtime.getRuntime().exec(precopyStatusUpdate_cmd);
												  status = process.waitFor();
										        return;
									   }
							  
							  //count the rows of the source table and enter the result into the management table while checking for errors thrown by sqlcmd
							  System.out.println("count");
							  process = Runtime.getRuntime().exec(sourceTableCount_cmd);
							  status = process.waitFor();
							  System.out.println(status); 
							  input = new BufferedReader(new InputStreamReader(process.getInputStream()));
									   while ((line = input.readLine()) != null) 
									   {
										  inputLog=inputLog+line+"\n";
									   }
									   input.close();
									   System.out.println(inputLog);
									   if(inputLog.toLowerCase().contains("Msg".toLowerCase()))
									   {
										        JOptionPane.showMessageDialog(null, inputLog, "Error", JOptionPane.ERROR_MESSAGE);
										        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
										        process = Runtime.getRuntime().exec(precopyStatusUpdate_cmd);
												  status = process.waitFor();
										        return;
									   }
									   System.out.println(inputLog);
									   error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
									   while ((line = error.readLine()) != null) 
									   {
										  errorLog=errorLog+line+"\n";
									   }
									   error.close();
									   System.out.println(errorLog);
									   if(errorLog.toLowerCase().contains("error".toLowerCase()))
									   {
										        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
										        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
										        process = Runtime.getRuntime().exec(precopyStatusUpdate_cmd);
												  status = process.waitFor();
										        return;
									   }
							  
									   
							  //calculate checksum of the source table and enter the result into the management table while checking for errors thrown by sqlcmd
							  System.out.println("checksum");
							  process = Runtime.getRuntime().exec(sourceChecksum_cmd);
							  status = process.waitFor();
							  System.out.println(status); 
							  input = new BufferedReader(new InputStreamReader(process.getInputStream()));
									  while ((line = input.readLine()) != null) 
												   {
													  inputLog=inputLog+line+"\n";
												   }
									  input.close();
									  System.out.println(inputLog);
									  if(inputLog.toLowerCase().contains("Msg".toLowerCase()))
									   {
										        JOptionPane.showMessageDialog(null, inputLog, "Error", JOptionPane.ERROR_MESSAGE);
										        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
										        process = Runtime.getRuntime().exec(precopyStatusUpdate_cmd);
												  status = process.waitFor();
										        return;
									   }
									  
									  error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
									   while ((line = error.readLine()) != null) 
									   {
										  errorLog=errorLog+line+"\n";
									   }
									   error.close();
									   System.out.println(errorLog);
									   if(errorLog.toLowerCase().contains("error".toLowerCase()))
									   {
										        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
										        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
										        process = Runtime.getRuntime().exec(precopyStatusUpdate_cmd);
												  status = process.waitFor();
										        return;
									   }
							  
									   
						       //copy the source table to destination database while checking for errors thrown by sqlcmd
									   System.out.println("copy");
										  process = Runtime.getRuntime().exec(tableCopy_cmd);
										  status = process.waitFor();
										  System.out.println(status); 
										  input = new BufferedReader(new InputStreamReader(process.getInputStream()));
												  while ((line = input.readLine()) != null) 
															   {
																  inputLog=inputLog+line+"\n";
															   }
												  input.close();
												  System.out.println(inputLog);
												  if(inputLog.toLowerCase().contains("Msg".toLowerCase()))
												   {
													        JOptionPane.showMessageDialog(null, inputLog, "Error", JOptionPane.ERROR_MESSAGE);
													        process = Runtime.getRuntime().exec(postcopyStatusUpdate_cmd);
															  status = process.waitFor();
															  JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
													        return;
												   }
												  error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
												  while ((line = error.readLine()) != null) 
												   {
													  errorLog=errorLog+line+"\n";
												   }
												   error.close();
												   System.out.println(errorLog);
												   if(errorLog.toLowerCase().contains("error".toLowerCase()))
												   {
													        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
													        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
													        process = Runtime.getRuntime().exec(postcopyStatusUpdate_cmd);
															  status = process.waitFor();
													        return;
												   }
										  
												   
							 //calculate checksum and enter the result into the management table while checking for errors thrown by sqlcmd   
										 System.out.println("checksum");
										 process = Runtime.getRuntime().exec(destChecksum_cmd);
										 status = process.waitFor();
										 System.out.println(status); 
										 input = new BufferedReader(new InputStreamReader(process.getInputStream()));
												 while ((line = input.readLine()) != null) 
															 {
															     inputLog=inputLog+line+"\n";
															 }
												input.close();
												System.out.println(inputLog);
												if(inputLog.toLowerCase().contains("Msg".toLowerCase()))
												   {
													        JOptionPane.showMessageDialog(null, inputLog, "Error", JOptionPane.ERROR_MESSAGE);
													        process = Runtime.getRuntime().exec(postcopyStatusUpdate_cmd);
															  status = process.waitFor();
															  JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
													        return;
												   }
															  
												error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
												while ((line = error.readLine()) != null) 
												 {
												      errorLog=errorLog+line+"\n";
												 }
												 error.close();
												 System.out.println(errorLog);
												 if(errorLog.toLowerCase().contains("error".toLowerCase()))
												   {
													        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
													        process = Runtime.getRuntime().exec(postcopyStatusUpdate_cmd);
															  status = process.waitFor();
													        return;
												   }
										  

															   
							 //count rows and enter the result into the management table while checking for errors thrown by sqlcmd
										 System.out.println("count");
										 process = Runtime.getRuntime().exec(destTableCount_cmd);
										 status = process.waitFor();
										 input = new BufferedReader(new InputStreamReader(process.getInputStream()));
										 		while ((line = input.readLine()) != null) 
										 				{
														inputLog=inputLog+line+"\n";
														}
												input.close();
												System.out.println(inputLog);
												if(inputLog.toLowerCase().contains("Msg".toLowerCase()))
												   {
													        JOptionPane.showMessageDialog(null, inputLog, "Error", JOptionPane.ERROR_MESSAGE);
													        process = Runtime.getRuntime().exec(postcopyStatusUpdate_cmd);
															  status = process.waitFor();
															  JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
													        return;
												   }
												error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
												while ((line = error.readLine()) != null) 
												{
													errorLog=errorLog+line+"\n";
											    }
												error.close();
												System.out.println(errorLog);
												if(errorLog.toLowerCase().contains("error".toLowerCase()))
												   {
													        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
													        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
													        process = Runtime.getRuntime().exec(postcopyStatusUpdate_cmd);
															  status = process.waitFor();
													        return;
												   }
										  
												
							//update the CopyStatus on the management table to success if it reached this far and the two checksums are equivalent
							System.out.println("update");
							process = Runtime.getRuntime().exec(copyStatusUpdate_cmd);
							status = process.waitFor();
							input = new BufferedReader(new InputStreamReader(process.getInputStream()));
							while ((line = input.readLine()) != null) 
								{
								inputLog=inputLog+line+"\n";
								}
							input.close();
							System.out.println(inputLog);
							
							error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
							while ((line = error.readLine()) != null) 
								{
								errorLog=errorLog+line+"\n";
								}
							error.close();
							System.out.println(errorLog);
							if(errorLog.toLowerCase().contains("error".toLowerCase()))
							   {
								        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
								        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
								        return;
							   }
							
							//drop corrupted tables and run 
							System.out.println("drop");
							process = Runtime.getRuntime().exec(dropCorrupted_cmd);
							status = process.waitFor();
							input = new BufferedReader(new InputStreamReader(process.getInputStream()));
							while ((line = input.readLine()) != null) 
								{
								inputLog=inputLog+line+"\n";
								}
							input.close();
							System.out.println(inputLog);

							error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
							while ((line = error.readLine()) != null) 
								{
								errorLog=errorLog+line+"\n";
								}
							error.close();
							System.out.println(errorLog);
							if(errorLog.toLowerCase().contains("error".toLowerCase()))
							   {
								        JOptionPane.showMessageDialog(null, errorLog, "Error", JOptionPane.ERROR_MESSAGE);
								        JOptionPane.showMessageDialog(null, "The copy process has been canceled", "Canceled", JOptionPane.ERROR_MESSAGE);
								        return;
							   }
							// show the user that the table has been copied and start the process over for the next table if multiple tables
							JOptionPane.showMessageDialog(null, table[i]+ " has finished copying from "+sIP +" to "+ dIP, "Copy Finished", JOptionPane.INFORMATION_MESSAGE);
																		   
						  }
						    catch (Exception err) {
							      err.printStackTrace();
							    }
			        }
						  JOptionPane.showMessageDialog(null, "The table(s) have finished copying", "Copy Finished", JOptionPane.INFORMATION_MESSAGE);
			        }
			        else 
			        {
			            System.out.println("Cancelled");
			        }
			  }

			
		}

    }
    // method to save space when constructing popup GridLayout
    void skipRow(JPanel p, int columns){
    	for(int i=0; i<columns;i++) 
    	p.add(new JLabel());

    }

}