'use strict';

describe('services/sourceService.js', function () {

  var $source = null;

  beforeEach(module('genisis'));

  beforeEach(function () {
    inject(function (source) {
      $source = source;
    });
  });

  it('service exists', function () {
    expect($source).not.toBeNull();
  });

  describe('$source.toName() function', function () {
    it('exists', function () {
      expect($source.toName).toBeDefined();
    });

    it('returns a name given a source ID', function () {
      expect($source.toName(1)).toEqual('Survey Data');
      expect($source.toName(2)).toEqual('Genomic Data');
      expect($source.toName(3)).toEqual('Clinical Data');
    });

    it('returns None if no source ID is given', function () {
      expect($source.toName()).toEqual('None');
    });

    it('retuns None if the source ID does not exist', function () {
      expect($source.toName(999)).toEqual('None');
    });
  });

  describe('$source.find() function', function () {
    it('exists', function () {
      expect($source.find).toBeDefined();
    });

    it('returns the source data for the given ID', function () {
      expect($source.find(1)).toEqual({
        id: 1,
        name: 'Survey Data'
      });
      expect($source.find(2)).toEqual({
        id: 2,
        name: 'Genomic Data'
      });
      expect($source.find(3)).toEqual({
        id: 3,
        name: 'Clinical Data'
      });
    });

    it('returns null if the source data is not found', function () {
      expect($source.find(999)).toEqual(null);
    });

    it('returns null if no ID is given', function () {
      expect($source.find()).toEqual(null);
    });
  });

  describe('$sources.get() function', function () {
    it('exists', function () {
      expect($source.get).toBeDefined();
    });

    it('returns an array of source objects', function () {
      expect($source.get()).toEqual([{
        id: 3,
        name: 'Clinical Data'
      }, {
        id: 2,
        name: 'Genomic Data'
      }, {
        id: 1,
        name: 'Survey Data'
      }]);
    });
  });
});