'use strict';

describe('navigation/navigation.js', function () {

  beforeEach(module('genisis'));

  var $controller, $scope, $user, $location, $rootScope;

  beforeEach(
    inject(function (_$rootScope_, _$controller_, _user_, _$location_) {
      $controller = _$controller_;
      $rootScope = _$rootScope_;
      $user = _user_;
      $location = _$location_;
      $scope = $rootScope.$new();

      spyOn($location, 'path');
      spyOn($user, 'permissions');

      $controller('navigationCtrl', {
        $scope: $scope,
        $location: $location,
        $rootScope: $rootScope,
        $user: $user
      });
    })
  );

  it('has $scope.tabs', function () {
    expect($scope.tabs).toBeDefined();
    expect($scope.tabs.length).toEqual(4);
  });

  describe('$scope.userTabs() function', function () {

    it('exists', function () {
      expect($scope.userTabs).toBeDefined();
    });

    it('returns tabs specific to researchers', function () {
      $user.permissions.and.returnValue('researcher');
      expect($scope.userTabs().length).toEqual(1);
    });

    it('returns tabs specific to data managers', function () {
      $user.permissions.and.returnValue('manager');
      expect($scope.userTabs().length).toEqual(1);
    });

    it('returns tabs specific to admins', function () {
      $user.permissions.and.returnValue('admin');
      expect($scope.userTabs().length).toEqual(1);
    });
  });

  describe('$scope.changeTab() function', function () {

    it('calls $location.path()', function () {
      var tab = {
        path: '/dashboard'
      };
      $scope.changeTab(tab);
      expect($location.path).toHaveBeenCalled();
    });
  });

  describe('changes active tab on $routeChangeSuccess', function () {

    it('resets $rootScope.errors', function () {
      $rootScope.errors = ['test'];
      $rootScope.$broadcast('$routeChangeSuccess');
      expect($rootScope.errors.length).toEqual(0);
    });

    it('resets $rootScope.warnings', function () {
      $rootScope.warnings = ['test'];
      $rootScope.$broadcast('$routeChangeSuccess');
      expect($rootScope.warnings.length).toEqual(0);
    });

    it(
      'sets the active tab in $scope.tabs to match the $location.path()',
      function () {
        $scope.tabs[0].active = false;
        $location.path.and.returnValue('/dashboard');
        $rootScope.$broadcast('$routeChangeSuccess');
        expect($scope.tabs[0].active).toEqual(true);
      }
    );
  });
});