'use strict';

angular.module('genisis', [
    'ngRoute',
    'ngCookies',
    'genisis.environment'
  ])
  .config(['$routeProvider',
    function ($routeProvider) {
      $routeProvider
        .when('/dashboard', {
          templateUrl: 'dashboard/dashboard.html'
        })
        .when('/requests', {
          templateUrl: 'requests/requests.html'
        })
        .when('/requests/:id', {
          templateUrl: 'requests/editRequest.html'
        })
        .when('/createRequest', {
          templateUrl: 'requests/createRequest.html'
        })
        .when('/requestHistory/:id', {
          templateUrl: 'requests/requestHistory.html'
        })
        .when('/studyApprovals', {
          templateUrl: 'studies/studyApproval.html'
        })
        .when('/studyApprovals/:id', {
          templateUrl: 'studies/editStudyApproval.html'
        })
        .when('/createStudy', {
          templateUrl: 'studies/createStudyApproval.html'
        })
        .when('/', {
          templateUrl: 'login/login.html'
        })
        .otherwise('/', {
          templateUrl: 'login/login.html'
        });
    }
  ]);