package gov.va.genisis2.model;

import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

//import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@Entity
@Table(name = "StudyApproval", schema = "dbo")
@JsonIgnoreProperties({"processId", "approvalIdObtained", "modifiedOn", "associatedStudyApproval1", "associatedStudyApproval2", "associatedStudyApproval3"})
public class StudyApproval implements java.io.Serializable {


	private int id;
	 
	private int processId;
	private String approvalIdObtained;
	private String title;

	private String description;
	
	private Date createdOn;
	
	private Date modifiedOn;
	private String createdBy;
	private String modifiedBy;
	
	private Integer associatedStudyApproval1;
	
	private Integer associatedStudyApproval2;
	
	private Integer associatedStudyApproval3;
    
	private String obtained;
	
	
	
	@Transient
	public String getObtained() {
		return obtained;
	}

	public void setObtained(String obtained) {
		this.obtained = obtained;
	}

	private List<Integer> associatedApprovals;
	
	@Transient
	public List<Integer> getAssociatedApprovals() {
		return associatedApprovals;
	}

	public void setAssociatedApprovals(List<Integer> associatedApprovals) {
		this.associatedApprovals = associatedApprovals;
	}

	public StudyApproval() {
	}

	public StudyApproval(int id, int processId) {
		this.id = id;
		this.processId = processId;
	}

	public StudyApproval(String approvalIdObtained, int id, int processId,
			String title, String description, Date createdOn, Date modifiedOn,
			String createdBy, String modifiedBy,
			Integer associatedStudyApproval1, Integer associatedStudyApproval2,
			Integer associatedStudyApproval3) {
		this.approvalIdObtained = approvalIdObtained;
		this.id = id;
		this.processId = processId;
		this.title = title;
		this.description = description;
		this.createdOn = createdOn;
		this.modifiedOn = modifiedOn;
		this.createdBy = createdBy;
		this.modifiedBy = modifiedBy;
		this.associatedStudyApproval1 = associatedStudyApproval1;
		this.associatedStudyApproval2 = associatedStudyApproval2;
		this.associatedStudyApproval3 = associatedStudyApproval3;
	}

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}

	@Column(name = "ProcessId", nullable = false)
	public int getProcessId() {
		return this.processId;
	}

	public void setProcessId(int processId) {
		this.processId = processId;
	}

	@Column(name = "ApprovalIdObtained")
	public String getApprovalIdObtained() {
		return this.approvalIdObtained;
	}

	public void setApprovalIdObtained(String approvalIdObtained) {
		this.approvalIdObtained = approvalIdObtained;
	}

	@Column(name = "Title", length = 50)
	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name = "Description", length = 3000)
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CreatedOn", length = 23)
	public Date getCreatedOn() {
		return this.createdOn;
	}

	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "ModifiedOn", length = 23)
	public Date getModifiedOn() {
		return this.modifiedOn;
	}
	
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	@Column(name = "CreatedBy", length = 50)
	public String getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "ModifiedBy", length = 50)
	public String getModifiedBy() {
		return this.modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	
	@Column(name = "AssociatedStudyApproval1")
	public Integer getAssociatedStudyApproval1() {
		return this.associatedStudyApproval1;
	}

	public void setAssociatedStudyApproval1(Integer associatedStudyApproval1) {
		this.associatedStudyApproval1 = associatedStudyApproval1;
	}

	@Column(name = "AssociatedStudyApproval2")
	public Integer getAssociatedStudyApproval2() {
		return this.associatedStudyApproval2;
	}

	public void setAssociatedStudyApproval2(Integer associatedStudyApproval2) {
		this.associatedStudyApproval2 = associatedStudyApproval2;
	}

	@Column(name = "AssociatedStudyApproval3")
	public Integer getAssociatedStudyApproval3() {
		return this.associatedStudyApproval3;
	}

	public void setAssociatedStudyApproval3(Integer associatedStudyApproval3) {
		this.associatedStudyApproval3 = associatedStudyApproval3;
	}

}
