/**
 * 
 */
package gov.va.genisis2.dao.impl;

import gov.va.genisis2.dao.IStudyApprovalDao;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.sun.media.jfxmedia.logging.Logger;

/**
 * @author 586338
 *
 */
@Repository
@Transactional(value="transactionManager")
public class StudyApprovalDao implements IStudyApprovalDao {

	private HibernateTemplate hibernateTemplate;

	public HibernateTemplate getHibernateTemplate() {
		return hibernateTemplate;
	}

	@Autowired
	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}

	public int createStudyApproval(StudyApproval entity) {
		int id = 0;
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		EntityTransaction transaction = null;
		try {
			transaction = entityManager.getTransaction();
			transaction.begin();
			entityManager.persist(entity);
			transaction.commit();
			id = entity.getId();
		} catch (RuntimeException e) {
			if (transaction != null)
				transaction.rollback();
		} finally {
			entityManager.close();
		}
		return id;
	}
	
	public int updateStudyApproval(StudyApproval entity) {
		hibernateTemplate.saveOrUpdate(entity);
		return entity.getId();
	}

	public StudyApproval getStudyApprovalsByID(int id) {
		StudyApproval studyApproval = (StudyApproval) hibernateTemplate.get(
				StudyApproval.class, id);
		return studyApproval;
	}

	public List<StudyApproval> getStudyApprovalsByUID(String uid) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<StudyApproval> query = criteriaBuilder
				.createQuery(StudyApproval.class);
		Root<StudyApproval> root = query.from(StudyApproval.class);
		query.where(criteriaBuilder.equal(root.get("createdBy"), uid));
		query.select(root);
		List<StudyApproval> studyApprovalList = entityManager
				.createQuery(query).getResultList();
		return studyApprovalList;
	}

	public List<StudyApproval> getStudyApprovals() {
		List<StudyApproval> studyApprovalList = (List<StudyApproval>) hibernateTemplate
				.find("from StudyApproval");
		return studyApprovalList;
	}

}
