/**
 * 
 */
package gov.va.genisis2.dao.impl;

import gov.va.genisis2.dao.IRequestDao;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author 586338
 *
 */
@Repository
@Transactional(value="transactionManager")
public class RequestDao implements IRequestDao {
	private final org.slf4j.Logger Logger = LoggerFactory
			.getLogger(RequestDao.class);

	
	@Autowired
	@Qualifier("hibernateTemplate")
	private HibernateTemplate hibernateTemplate;
	
	
	
	public HibernateTemplate getHibernateTemplate() {
		return hibernateTemplate;
	}



	@Autowired
	public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
		this.hibernateTemplate = hibernateTemplate;
	}


	
	
	public int createRequest(final Request entity) {
		int id = 0;
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		EntityTransaction transaction = null;
		try {
			transaction = entityManager.getTransaction();
			transaction.begin();
			entityManager.persist(entity);
			transaction.commit();
			Logger.info("RequestDao:  Request Created.");
			id = entity.getId();
		} catch (RuntimeException e) {
			Logger.error("RequestDao:  Request Creation failed. Transaction Rolled back.");
			if (transaction != null)
				transaction.rollback();
		} finally {
			entityManager.close();
		}
		return id;
	}


	
	public List<Request> getRequestsByUID(String uid) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<Request> query = criteriaBuilder
				.createQuery(Request.class);
		Root<Request> root = query.from(Request.class);
		Predicate condition1 = criteriaBuilder.equal(root.get("createdBy"), uid);
	    Predicate condition2 = criteriaBuilder.equal(root.get("approverId"), uid);
	  //  Predicate condition3 = criteriaBuilder.notEqual(root.get("statusDescription"), "Draft");
	    Predicate conditions = criteriaBuilder.or(condition1, condition2 );
	    query.where(conditions);
	    
	    List<Request> requestList = entityManager
				.createQuery(query).getResultList();
		return requestList;
	}



	public Request getRequestsById(int id) {
		Request request = (Request) hibernateTemplate.get(
				Request.class, id);
		return request;
	}

	
	
	public List<Request> getAllRequests() {
		List<Request> requestList = (List<Request>) hibernateTemplate
				.find("from Request");
		return requestList;
	}

	
	
	public List<Request> getAllRequestsByStudyApproval(int studyApprovalId) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<Request> query = criteriaBuilder
				.createQuery(Request.class);
		Root<Request> root = query.from(Request.class);
		query.where(criteriaBuilder.equal(root.get("studyApproval"), studyApprovalId));
		query.select(root);
		List<Request> requestList = entityManager
				.createQuery(query).getResultList();
		return requestList;
	}

	

	public List<Request> getAllRequestsByStaus(String status) {
		EntityManager entityManager = hibernateTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<Request> query = criteriaBuilder
				.createQuery(Request.class);
		Root<Request> root = query.from(Request.class);
		query.where(criteriaBuilder.equal(root.get("statusDescription"), status));
		query.select(root);
		List<Request> requestList = entityManager
				.createQuery(query).getResultList();
		return requestList;
	}


	
	public int submitOrModify(Request entity) {
		hibernateTemplate.saveOrUpdate(entity);
		return entity.getId();
	}



	
	public RequestType getRequestType(int id) {
		RequestType requestType = (RequestType) hibernateTemplate.get(
				RequestType.class, id);
		return requestType;
	}

	public Source getSource(int id) {
		Source source = (Source) hibernateTemplate.get(Source.class, id);
		return source;
	}

}
