/**
 * 
 */
package gov.va.genisis2.dao.impl;

import gov.va.genisis2.dao.IJbpmDao;
import gov.va.genisis2.model.AuditTaskImpl;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author 586338
 *
 */
@Repository
@Transactional(value="jbpmTransactionManager")
public class JBPMDao implements IJbpmDao {

	@Autowired
	@Qualifier("hibernateJBPMTemplate")
	private HibernateTemplate hibernateJBPMTemplate;

	public List<AuditTaskImpl> getRequestTracking(Long processId) {
		EntityManager entityManager = hibernateJBPMTemplate.getSessionFactory()
				.createEntityManager();
		CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
		CriteriaQuery<AuditTaskImpl> query = criteriaBuilder
				.createQuery(AuditTaskImpl.class);
		Root<AuditTaskImpl> root = query.from(AuditTaskImpl.class);
		Predicate condition1 = criteriaBuilder.equal(
				root.get("processInstanceId"), processId);
		
		Predicate condition2 = criteriaBuilder.equal(
				root.get("status"), "Completed");
		query.where(condition1, condition2);
		List<AuditTaskImpl> auditLogList = entityManager.createQuery(query)
				.getResultList();
		return auditLogList;
	}

}
