/**
 * 
 */
package  gov.va.genisis2.configuration;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

/**
 * @author 586338
 *
 */
@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
@PropertySource("file:${jboss.server.config.dir}/genisis2.properties")
public class JBPMRestClientConfig {

	@Value("${jbpm.process.start}")
	private String startProcess;

	@Value("${jbpm.process.complete.researcher}")
	private String completeResearcher;

	@Value("${jbpm.process.complete.approver}")
	private String completeApprover;

	public Map<String, String> readPropertyValues() {
		Map<String, String> properties = new HashMap<String, String>();
		properties.put("startProcess", startProcess);
		properties.put("completeApprover", completeApprover);
		properties.put("completeResearcher", completeResearcher);
		return properties;
	}

	@Bean
	public Map  accessPropertyValues() throws Exception
	{
		Map<String, String> properties = new HashMap<String, String>();
		properties.put("startProcess", startProcess);
		properties.put("completeApprover", completeApprover);
		properties.put("completeResearcher", completeResearcher);
		return properties;
	}
	
	@Bean
	public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
		return new PropertySourcesPlaceholderConfigurer();
	}
	
}