/**
 * 
 */
package gov.va.genisis2.bo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

/**
 * @author 586338
 *
 */
@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
@PropertySource("file:${jboss.server.config.dir}/genisis2.properties")
public class JBPMClient {
	private static final org.slf4j.Logger Logger = LoggerFactory
			.getLogger(JBPMClient.class);

	public static long startWorkFlowProcess(String user, String url) {
		Logger.info("Starting work flow..");
	
		long processInstanceId = 0;
		url = url + user;
		Logger.info("URL: " +url);
		CloseableHttpClient httpclient = HttpClients.createDefault();
		HttpGet httpGet = new HttpGet(url);
		CloseableHttpResponse response = null;
		try {
			response = httpclient.execute(httpGet);
			Logger.info("Workflow status: " + response.getStatusLine().getStatusCode());
			
	        if (200 == response.getStatusLine().getStatusCode()) {
			HttpEntity entity = response.getEntity();
			BufferedReader br;
			br = new BufferedReader(new InputStreamReader(response.getEntity()
					.getContent()));
			String line = "";
			while ((line = br.readLine()) != null) {
				processInstanceId = Long.parseLong(line);
			}
			EntityUtils.consume(entity);
	        }

		} catch (ClientProtocolException e) {
			Logger.error("System Error starting workflow for requestor :"
					+ user + "Reason: " + e.getMessage());
		} catch (IOException e) {
			Logger.error("System Error starting workflow for requestor :"
					+ user + "Reason: " + e.getMessage());
		} finally {
			try {
				response.close();
			} catch (IOException e) {
				Logger.error("System error. Unable to close response. ");
			}
		}
		return processInstanceId;
	}

	public static boolean completeProcessApprover(long processInstanceId,
			JSONObject json, String url) {
		Logger.info("Completing Approver process..");

		String pid = String.valueOf(processInstanceId);
		url = url + pid;
		Logger.info("URL: " +url);
		boolean success = false;

		CloseableHttpClient httpclient = HttpClients.createDefault();

		StringEntity requestEntity = new StringEntity(json.toString(),
				ContentType.APPLICATION_JSON);

		HttpPost postMethod = new HttpPost(url);
		postMethod.setEntity(requestEntity);

		try {
			HttpResponse resp = httpclient.execute(postMethod);
			Logger.info("Status:" + resp.getStatusLine().getStatusCode());
			if (200 == resp.getStatusLine().getStatusCode())
				success = true;
		} catch (ClientProtocolException e) {
			Logger.error("System Error completing approver request. Reason: "
					+ e.getMessage());

		} catch (IOException e) {
			Logger.error("System Error completing approver request. Reason: "
					+ e.getMessage());
		}

		return success;
	}

	public static boolean completeProcessRequestor(long processInstanceId,
			JSONObject json, String url) {
		Logger.info("Completing Requestor process..");
		String pid = String.valueOf(processInstanceId);
		url = url + pid;
		Logger.info("URL: " +url);

		boolean success = false;

		CloseableHttpClient httpclient = HttpClients.createDefault();

		StringEntity requestEntity = new StringEntity(json.toString(),
				ContentType.APPLICATION_JSON);

		HttpPost postMethod = new HttpPost(url);
		postMethod.setEntity(requestEntity);

		try {
			HttpResponse resp = httpclient.execute(postMethod);
			Logger.info("Status:" + resp.getStatusLine().getStatusCode());
			if (200 == resp.getStatusLine().getStatusCode())
				success = true;
		} catch (ClientProtocolException e) {

			Logger.error("System Error completing approver request. Reason: "
					+ e.getMessage());
		} catch (IOException e) {
			Logger.error("System Error completing approver request. Reason: "
					+ e.getMessage());
		}

		return success;
	}

	@Bean
	public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
		return new PropertySourcesPlaceholderConfigurer();
	}
}
