/**
 * 
 */
package gov.va.genisis2.bo;

import static java.lang.Math.toIntExact;
import gov.va.genisis2.configuration.JBPMRestClientConfig;
import gov.va.genisis2.model.AuditTaskImpl;
import gov.va.genisis2.model.LDAPLogger;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.service.impl.JbpmService;
import gov.va.genisis2.service.impl.LdapService;
import gov.va.genisis2.service.impl.RequestService;
import gov.va.genisis2.service.impl.StudyApprovalService;
import gov.va.genisis2.util.ldap.Transformer;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author 586338
 *
 */
public class BusinessService implements IBusiness {
	private final org.slf4j.Logger Logger = LoggerFactory
			.getLogger(BusinessService.class);
	public static String newline = "<br />";
	
	private final static String NO_RECORD_FOUND = "No records found.";
	private final static String REQUEST_SENT = "Sent";
	private final static String REQUEST_DENIED = "Denied";
	private final static String REQUEST_RETURNED = "Returned";
	private final static String REQUEST_UPDATE = "Update";
	private final static String REQUEST_SUBMIT = "Submitted";
	
	private final static String REQUEST_ACCEPTED = "RequestAccepted";
	private final static String REQUEST_NOT_ACCEPTED = "RequestNotAccepted";
	private final static String RESULTS_ACCEPTED = "ResultsAccepted";
	private final static String RESULTS_NOT_ACCEPTED="ResultsNotAccepted";
	
	
	private RequestService requestService;
	private StudyApprovalService studyApprovalService;
	private LdapService ldapService;
	private Transformer transformer;
	private JbpmService jbpmService;
	
	private JBPMRestClientConfig  jbpmRestClientConfig;
	

	public JBPMRestClientConfig getJbpmRestClientConfig() {
		return jbpmRestClientConfig;
	}


	@Autowired
	public void setJbpmRestClientConfig(JBPMRestClientConfig jbpmRestClientConfig) {
		this.jbpmRestClientConfig = jbpmRestClientConfig;
	}



	public Transformer getTransformer() {
		return transformer;
	}

	
	
	public JbpmService getJbpmService() {
		return jbpmService;
	}


	@Autowired
	public void setJbpmService(JbpmService jbpmService) {
		this.jbpmService = jbpmService;
	}



	@Autowired
	public void setTransformer(Transformer transformer) {
		this.transformer = transformer;
	}

	public RequestService getRequestService() {
		return requestService;
	}

	@Autowired
	public void setRequestService(RequestService requestService) {
		this.requestService = requestService;
	}

	public StudyApprovalService getStudyApprovalService() {
		return studyApprovalService;
	}

	@Autowired
	public void setStudyApprovalService(
			StudyApprovalService studyApprovalService) {
		this.studyApprovalService = studyApprovalService;
	}

	public LdapService getLdapService() {
		return ldapService;
	}

	@Autowired
	public void setLdapService(LdapService ldapService) {
		this.ldapService = ldapService;
	}

	public ResponseWrapper<?> createStudyApproval(StudyApproval studyApproval) {
		Logger.info("BusinessService:  createStudyApproval");
		ResponseWrapper wrapper = new ResponseWrapper();
		studyApproval=BusinessHelper.handleStudyApprovalPayload(studyApproval);
		int id = getStudyApprovalService().createStudyApproval(studyApproval);
		if (id > 0) {
			wrapper = this.getStudyApprovalsByID(id);
			wrapper.setSuccess(true);
			wrapper.setMessage(null); }
		else {
			List<StudyApproval> studyApprovalList = BusinessHelper
					.prepareStudyApprovalResponsePayload(Arrays
							.asList(studyApproval));
			wrapper.setResponse(studyApprovalList.get(0));
			wrapper.setSuccess(false);
			wrapper.setMessage("Unable to create Study Approval");
		}
		return wrapper;
	}

	public ResponseWrapper<?> updateStudyApproval(StudyApproval studyApproval) {
		Logger.info("BusinessService: updateStudyApproval");
		ResponseWrapper wrapper = new ResponseWrapper();
		studyApproval = BusinessHelper.handleStudyApprovalPayload(studyApproval);
		int id = studyApproval.getId();
		if (id > 0) {
			getStudyApprovalService().updateStudyApproval(studyApproval);
			wrapper = this.getStudyApprovalsByID(id);
		} else {
			List<StudyApproval> studyApprovalList = BusinessHelper.prepareStudyApprovalResponsePayload(Arrays.asList(studyApproval));
			wrapper.setResponse(studyApprovalList.get(0));
			wrapper.setSuccess(false);
			wrapper.setMessage("Unable to update Study Approval");
		}
		return wrapper;
	}
	
	public ResponseWrapper<?> getStudyApprovalsByID(int id) {
		Logger.info("BusinessService:  getStudyApprovalsByID:"+id);
		ResponseWrapper wrapper = new ResponseWrapper();
		StudyApproval studyApproval = getStudyApprovalService()
				.getStudyApprovalsByID(id);
		if (studyApproval != null) {
			List<StudyApproval> studyApprovalList = BusinessHelper
					.prepareStudyApprovalResponsePayload(Arrays
							.asList(studyApproval));
			wrapper.setResponse(studyApprovalList.get(0));
		}
		createResponseWrapper(wrapper);
		return wrapper;
	}

	public ResponseWrapper getStudyApprovalsByUID(String uid) {
		Logger.info("BusinessService:  getStudyApprovals by user:"+uid);
		ResponseWrapper wrapper = new ResponseWrapper();
		List<StudyApproval> studyApprovalList = getStudyApprovalService()
				.getStudyApprovalsByUID(uid);
		studyApprovalList = BusinessHelper
				.prepareStudyApprovalResponsePayload(studyApprovalList);
		wrapper.setResponse(studyApprovalList);
		createResponseWrapper(wrapper);
		return wrapper;
	}

	public ResponseWrapper<?> getStudyApprovals() {
		Logger.info("BusinessService:  getStudyApprovals");
		ResponseWrapper wrapper = new ResponseWrapper();
		List<StudyApproval> studyApprovalList = getStudyApprovalService()
				.getStudyApprovals();
		studyApprovalList = BusinessHelper
				.prepareStudyApprovalResponsePayload(studyApprovalList);
		wrapper.setResponse(studyApprovalList);
		createResponseWrapper(wrapper);
		return wrapper;
	}

	private ResponseWrapper createResponseWrapper(ResponseWrapper wrapper) {
		Logger.info("BusinessService:  creating Response Wrapper");
		if (wrapper == null) {
			wrapper.setMessage("Internal System Error. Could not perform requested Opeartion");
			wrapper.setResponse(null);
			wrapper.setSuccess(false);
			return wrapper;
		}

		if (wrapper.getResponse() == null) {
			wrapper.setSuccess(true);
			wrapper.setResponse(null);
			wrapper.setMessage(NO_RECORD_FOUND);
			return wrapper;

		} else {
			Object object = wrapper.getResponse();
			try {
				if (object instanceof ArrayList<?>
						|| object instanceof StudyApproval
						|| object instanceof Request) {
					if (object instanceof ArrayList<?>
							&& ((ArrayList<?>) object).get(0) instanceof StudyApproval) {
						if (((ArrayList) object).size() == 1) {
							StudyApproval studyApproval = (StudyApproval) ((ArrayList<?>) object)
									.get(0);
							wrapper.setResponse(studyApproval);
							wrapper.setSuccess(true);
							wrapper.setMessage(null);
							return wrapper;
						}
						else {
							wrapper.setSuccess(true);
							wrapper.setMessage(null);
						}

					} 
					
					else if (object instanceof ArrayList<?>
							&& ((ArrayList<?>) object).get(0) instanceof AuditTaskImpl) {
						if (((ArrayList) object).size() == 1) {
							AuditTaskImpl auditTaskImpl = (AuditTaskImpl) ((ArrayList<?>) object)
									.get(0);
							wrapper.setResponse(auditTaskImpl);
							wrapper.setSuccess(true);
							wrapper.setMessage(null);
							return wrapper;
						} else {
							wrapper.setSuccess(true);
							wrapper.setMessage(null);
						}

					}

					else {
						wrapper.setResponse(object);
						wrapper.setSuccess(true);
						wrapper.setMessage(null);
						return wrapper;
					}

				} else {
					wrapper.setSuccess(true);
					wrapper.setResponse(null);
					wrapper.setMessage(NO_RECORD_FOUND);
				}
			} catch (NullPointerException ex) {
				ex.printStackTrace();
			}
		}
		return wrapper;
	}

	public ResponseWrapper<?> ldapGetLoginDetailsByEmail(String email) {
		Logger.info("BusinessService:  ldap user by email:" + email);
		ResponseWrapper wrapper = new ResponseWrapper();
		String user = ldapService.getUserDetails(email);
		wrapper = this.populateUserDetails(user);
		return wrapper;
	}

	public ResponseWrapper<?> ldapGetLoginDetailsById(String id) {
		Logger.info("BusinessService:  ldap user by Id:" + id);
		ResponseWrapper wrapper = new ResponseWrapper();
		String user = ldapService.getUserDetails("cn", id);
		wrapper = this.populateUserDetails(user);
		return wrapper;
	}

	
	
	private ResponseWrapper<?> populateUserDetails(String user) {
		ResponseWrapper wrapper = new ResponseWrapper();
		try {
			Map<String, String> managerObject = new HashMap<String, String>();
			Map<String, String> userObject = new HashMap<String, String>();
			LDAPLogger ldapLogger = new LDAPLogger();

			if (!StringUtils.isBlank(user) && StringUtils.contains(user, ":")) {
				userObject = transformer.getLdapKeyValuePairs(user, userObject);
				String role = transformer.getRoleApprover(userObject.get("ou"),
						"ou");
				String manager = transformer.getRoleApprover(
						userObject.get("o"), "cn");

				String managerDetails = ldapService.getUserDetails("cn",
						manager);
				if (!StringUtils.isBlank(managerDetails)) {
					managerObject = transformer.getLdapKeyValuePairs(
							managerDetails, managerObject);
					managerObject.put("role", "approver");
				}
				if (!StringUtils.isBlank(role)) {
					userObject.put("role", role);
				}

				ldapLogger = transformer.getUser(userObject, managerObject);
				wrapper.setResponse(ldapLogger);
				wrapper.setMessage(null);
				wrapper.setSuccess(true);
			}
			
			else {
				wrapper.setResponse(null);
				wrapper.setSuccess(false);
				wrapper.setMessage("No records found.");

			}

		} catch (Throwable e) {
			wrapper.setSuccess(false);
			wrapper.setMessage("Internal System Error. Could not retrieve user login details.");
			wrapper.setResponse(null);
		}
		return wrapper;

	}

	
	public ResponseWrapper<?> createRequest(Request request) {
		Logger.info("BusinessService: createRequest" );
		ResponseWrapper wrapper = new ResponseWrapper();
		request=BusinessHelper.handleRequestPayload(request);
		
		String approverId=StringUtils.EMPTY;
		
		approverId = this.getRequestorApproverId(request);
		
		if (StringUtils.isBlank(request.getApproverId())) {
			request.setApproverId(approverId);
		}
		
		// Implement JBPM 
		boolean jbpmProcessIdRequired = true;
		if (request.getId() != 0) {
			Request existingRequest = getRequestService().getRequestsById(
					request.getId());
			if (existingRequest.getId() != 0) {
				jbpmProcessIdRequired = false;
			}
		}
		if (jbpmProcessIdRequired) {
			String processUrl=StringUtils.EMPTY;
			
			try {
				processUrl = (String) getJbpmRestClientConfig().accessPropertyValues().get("startProcess");
			} catch (Exception e) {
				Logger.error("Error occured while getting startProcess from Properties file " + e.getMessage());
			
			}
			
			if (!processUrl.isEmpty()) {
			long processInstanceId = JBPMClient.startWorkFlowProcess(request
					.getCreatedBy(),processUrl );
			int intProcessInstanceId = toIntExact(processInstanceId);
			request.setProcessId(intProcessInstanceId);
			}
		}
		//Implement JBPM ends
		
		if (request.getProcessId() == 0) {
			List<Request> requestList = BusinessHelper
					.prepareRequestResponsePayload(Arrays.asList(request));

			wrapper.setResponse(requestList.get(0));
			wrapper.setSuccess(false);
			wrapper.setMessage("Unable to create Request. Business process failed to start.");
			return wrapper;
		}
		
		int id = getRequestService().createRequest(request);
		if (id > 0) {
			wrapper = this.getRequestByID(id);
			wrapper.setSuccess(true);
			wrapper.setMessage(null); }
		else {
			List<Request> requestList = BusinessHelper.prepareRequestResponsePayload(Arrays
							.asList(request));
				
			wrapper.setResponse(requestList.get(0));
			wrapper.setSuccess(false);
			wrapper.setMessage("Unable to create Request");
		}
		return wrapper;
	}

	
	
	public ResponseWrapper<?> getRequestByID(int id) {
		Logger.info("BusinessService: get Request by Id:"  +id);
		ResponseWrapper wrapper = new ResponseWrapper();
		Request request = getRequestService().getRequestsById(id);
		if (request != null) {
			List<Request> requestList = BusinessHelper
					.prepareRequestResponsePayload(Arrays.asList(request));

			wrapper.setResponse(requestList.get(0));
		}
		createResponseWrapper(wrapper);
		return wrapper;
	}
	
	
	
	public ResponseWrapper<?> getRequestTrackingByID(int id) {
		Logger.info("BusinessService: get Request by Id:"  +id);
		ResponseWrapper wrapper = new ResponseWrapper();
		Request request = getRequestService().getRequestsById(id);
		if (request != null) {
			long processInstanceId = request.getProcessId();
			List<AuditTaskImpl> trackingList = jbpmService.getRequestTracking(processInstanceId);
			if (trackingList != null && trackingList.size()==0)
			wrapper.setResponse(null);
			else {
			wrapper.setResponse(trackingList);
			}
		}
		createResponseWrapper(wrapper);
		return wrapper;
	}
	
	

	
	public ResponseWrapper<?> getRequestsByUID(String uid) {
		Logger.info("BusinessService: get Request by User:"  +uid);
		ResponseWrapper wrapper = new ResponseWrapper();
		List<Request> requestList =getRequestService().getRequestsByUID(uid);
		requestList= this.filterRequestList(requestList, uid);
		requestList = BusinessHelper.prepareRequestResponsePayload(requestList);
		wrapper.setResponse(requestList);
		createResponseWrapper(wrapper);
		return wrapper;
	}

	private List<Request> filterRequestList(List<Request> requestList,
			String uid) {
		List<Request> filteredRequestList = new ArrayList<Request>();

		for (Request request : requestList) {
			if ( !(!StringUtils.equalsIgnoreCase(request.getCreatedBy(), uid)
					&& StringUtils.equalsIgnoreCase(
							request.getStatusDescription(), "Draft"))) {
				filteredRequestList.add(request);
			}
		}
		return filteredRequestList;
	}
	public ResponseWrapper<?> getAllRequests() {
		Logger.info("BusinessService: get all Requests");
		ResponseWrapper wrapper = new ResponseWrapper();
		List<Request> requestList =getRequestService().getAllRequests();
		Logger.info("Got Requests count:" + requestList.size());
		requestList = BusinessHelper.prepareRequestResponsePayload(requestList);
		wrapper.setResponse(requestList);
		createResponseWrapper(wrapper);
		return wrapper;
	}

	
	public ResponseWrapper<?> getAllRequestsByStudyApproval(int studyApprovalId) {
		Logger.info("BusinessService: getAllRequestsByStudyApproval:"+studyApprovalId);
		ResponseWrapper wrapper = new ResponseWrapper();
		List<Request> requestList =getRequestService().getAllRequestsByStudyApproval(studyApprovalId);
		requestList = BusinessHelper.prepareRequestResponsePayload(requestList);
		wrapper.setResponse(requestList);
		createResponseWrapper(wrapper);
		return wrapper;
	}


	public ResponseWrapper<?> getAllRequestsByStaus(String status) {
		Logger.info("BusinessService: get all Requests by Status:"+status);
		ResponseWrapper wrapper = new ResponseWrapper();
		List<Request> requestList =getRequestService().getAllRequestsByStaus(status);
		requestList = BusinessHelper.prepareRequestResponsePayload(requestList);
		wrapper.setResponse(requestList);
		createResponseWrapper(wrapper);
		return wrapper;
	}

	
	public ResponseWrapper<?> submitOrModify(Request request) {
		Logger.info("BusinessService: Sumbit/Modify Request");
		ResponseWrapper wrapper = new ResponseWrapper();
		wrapper= this.createRequest(request);
		return wrapper;
	}
	
	
	
	public  ResponseWrapper persist(int id, Request changeRequest,String operation) {
		Logger.info("BusinessService: Persisting: "	+ operation);
		ResponseWrapper wrapper = new ResponseWrapper();
		
		if (StringUtils.equalsIgnoreCase(operation, "Update")
				|| StringUtils.equalsIgnoreCase(operation, "Submitted")) {
			changeRequest = BusinessHelper.handleRequestPayload(changeRequest);
		}
		Request databaseRequest = requestService.getRequestsById(id);

		if (databaseRequest == null)
		{
			changeRequest.setId(id);
			wrapper.setResponse(changeRequest);
			wrapper.setMessage("No such request found in database");
			wrapper.setSuccess(false);
			return wrapper;
		}

		String status = StringUtils
				.trim(databaseRequest.getStatusDescription());
		/*if (StringUtils.equalsIgnoreCase(status, "Sent")
				|| StringUtils.equalsIgnoreCase(status, "Rejected")) {*/

		if ( StringUtils.equalsIgnoreCase(status, "Rejected")) {
			wrapper.setResponse(changeRequest);
			wrapper.setMessage("You can't submit this request.");
			wrapper.setSuccess(false);
			return wrapper;
		}
		
		
		if (StringUtils.isNotBlank(changeRequest.getReason())
				&& !StringUtils.equalsIgnoreCase(changeRequest.getReason(),
						databaseRequest.getComments())) {
			changeRequest.setComments(changeRequest.getReason());
		} else {
			changeRequest.setComments(databaseRequest.getComments());
		}
		
		

		if (!StringUtils.equals(operation, "Update"))
		changeRequest.setStatusDescription(operation);

		if ( changeRequest.getProcessId() == 0)
			changeRequest.setProcessId(databaseRequest.getProcessId());

		if (changeRequest.getRequestType() == 0)
			changeRequest.setRequestType(databaseRequest.getRequestType());

		if (changeRequest.getAssociatedRequest1() == null || changeRequest.getAssociatedRequest1() == 0)
			changeRequest.setAssociatedRequest1(databaseRequest
					.getAssociatedRequest1());

		if (changeRequest.getAssociatedRequest2() == null || changeRequest.getAssociatedRequest2() == 0 )
			changeRequest.setAssociatedRequest2(databaseRequest
					.getAssociatedRequest2());

		if (changeRequest.getAssociatedRequest3() == null || changeRequest.getAssociatedRequest3() == 0)
			changeRequest.setAssociatedRequest3(databaseRequest
					.getAssociatedRequest3());

		if (changeRequest.getStudyApproval() == null || changeRequest.getStudyApproval() == 0)
			changeRequest.setStudyApproval(databaseRequest.getStudyApproval());

		if (changeRequest.getSource() == 0)
			changeRequest.setSource(databaseRequest.getSource());

		if (StringUtils.isBlank(changeRequest.getStatusDescription()))
			changeRequest.setStatusDescription(databaseRequest
					.getStatusDescription());

		if (StringUtils.isBlank(changeRequest.getTitle()))
			changeRequest.setTitle(databaseRequest.getTitle());

		if (StringUtils.isBlank(changeRequest.getDescription()))
			changeRequest.setDescription(databaseRequest.getDescription());

		changeRequest.setModifiedOn(new Date());
		changeRequest.setModifiedBy(changeRequest.getCreatedBy());
		
		changeRequest.setCreatedBy(databaseRequest.getCreatedBy());
		changeRequest.setCreatedOn(databaseRequest.getCreatedOn());
		changeRequest.setApproverId(databaseRequest.getApproverId());
		
		changeRequest.setId(id);
		
		int submitOrModifyId = requestService.submitOrModify(changeRequest);

		if (submitOrModifyId > 0){
			wrapper = this.getRequestByID(submitOrModifyId);
			wrapper.setSuccess(true);
			wrapper.setMessage(null); 
			this.completeJBPMProcess(submitOrModifyId);
		    }
		else {
			List<Request> requestList = BusinessHelper
					.prepareRequestResponsePayload(Arrays.asList(changeRequest));

			wrapper.setResponse(requestList.get(0));
			wrapper.setSuccess(false);
			wrapper.setMessage("Unable to create Request");
		}
		return wrapper;
	}	
	
	
	private String getRequestorApproverId(Request request) {
		String approverId = StringUtils.EMPTY;

		String requestor = request.getCreatedBy();
		String user = ldapService.getUserDetails("cn", requestor);
		Object object = this.populateUserDetails(user);
		JSONObject jsonUser = new JSONObject(object);
		JSONObject response = jsonUser.getJSONObject("response");
		approverId = (String) response.getJSONObject("datamanager").get("id");

		return approverId;

	}
	
	
		private boolean completeJBPMProcess (int requestId)
	{
		boolean success=true;
		String from ="";
		String to="";
		String subject ="";
		String body ="";
		String requestorId="";
		String approverId="";
		String processUrl = StringUtils.EMPTY;
		
	
		Request request = getRequestService().getRequestsById(requestId);
		RequestType requestType= getRequestService().getRequestType(request.getRequestType());
		Source source = getRequestService().getSource(request.getSource());
		String user = ldapService.getUserDetails("cn", request.getCreatedBy());
		long processInstanceId = request.getProcessId();
		Object object= this.populateUserDetails(user);
		JSONObject jsonUser = new JSONObject(object);
		JSONObject response = jsonUser.getJSONObject("response");
		from=(String) response.get("email");
		to=(String) response.getJSONObject("datamanager").get("email");
		requestorId=(String) response.get("id");
		approverId=(String) response.getJSONObject("datamanager").get("id");
		String status = request.getStatusDescription();
	
	
		JSONObject json = new JSONObject();
		json.put("requestorId", requestorId);
		json.put("From", from);
		json.put("To", to);
		json.put("Subject", subject);
		json.put("Body", body);
		json.put("approverDecision", status);
		json.put("approverId", approverId);

		
		try {
			processUrl = (String) getJbpmRestClientConfig().accessPropertyValues().get("completeApprover");
		} catch (Exception e) {
			Logger.error("Error occured while getting completeApprover from Properties file " + e.getMessage());
		
		}
		
		
		if (StringUtils.equals(status, REQUEST_SUBMIT)) {
			subject = "ACTION REQUIRED:Submitted Request - " + request.getId() + "  - " + request.getTitle();
			body = "A new data request "
					+ request.getId()
					+ "  has been Submitted by "
					+ request.getCreatedBy()
					+ " for review. ";
					json.put("Subject", subject);
			json.put("Body", body);
			json.put("approverDecision", "");	
			
			try {
				processUrl = (String) getJbpmRestClientConfig().accessPropertyValues().get("completeResearcher");
			} catch (Exception e) {
				Logger.error("Error occured while getting completeResearcher from Properties file " + e.getMessage());
			
			}
			
			
			
			boolean completed = JBPMClient.completeProcessRequestor(
					processInstanceId, json,processUrl );
		}
		else if (StringUtils.equals(status,REQUEST_RETURNED ))
		{
			subject = "Returned Request - " + request.getId()
					+ "  - " + request.getTitle();
			body = "Your data request  "
					+ request.getId()
					+ "  has been Returned by "
					+ request.getModifiedBy()
					+ " for review. " + newline+  request.getComments();
			json.put("approverDecision", "return");	
			json.put("Subject", subject);
			json.put("Body", body);
			json.put("From", to);
			json.put("To", from);
			boolean completed = JBPMClient.completeProcessApprover(
					processInstanceId, json,processUrl);
		} else if (StringUtils.equals(status,REQUEST_DENIED ))
		{
			
			subject = "Request Denied - " + request.getId()
					+ "  - " + request.getTitle();
			body = "Your data request  "
					+ request.getId()
					+ "  has been Denied by " + request.getModifiedBy() 
					+newline+ request.getComments();
			json.put("approverDecision", "reject");	
			json.put("Subject", subject);
			json.put("Body", body);
			json.put("From", to);
			json.put("To", from);
			boolean completed = JBPMClient.completeProcessApprover(
					processInstanceId, json,processUrl);
			
		} else if (StringUtils.equals(status,REQUEST_SENT ))
		{
			subject = "ACTION REQUIRED: Genisis Data Request  - " + request.getId()
					+ "  - " + request.getTitle();
		
			body = "A new " +requestType.getDescription() + " data request "
					+ request.getId()
					+ "   has been reviewed by " + request.getModifiedBy() 
					+ " and determined to have sufficient information for data research. "  
					+newline +"Request ID: " + request.getId()
					+newline +"Request Type: " + requestType.getDescription()
					+newline +"Data Source: "+source.getDescription()
					+newline +"Approved Studies: "+request.getStudyApproval()
					+newline +"Description: "+request.getDescription();
			
					json.put("Subject", subject);
			json.put("approverDecision", "sent");		
			json.put("Body", body);
			json.put("From", to);
			json.put("To", "vinci.datasource@gmail.com");
			boolean completed = JBPMClient.completeProcessApprover(
					processInstanceId, json,processUrl);
		}
		
		else if (StringUtils.equals(status,REQUEST_NOT_ACCEPTED ))
		{
			subject = "Request No " + request.getId() + " Not Approved"
					+ "  - " + request.getTitle();
		
			body = "Your data request "
					+ request.getId()
					+ "   was Not Approved for data research. " 
					+newline +request.getComments();
					json.put("Subject", subject);
			json.put("fulfillmentDecision", "unfulfilled");		
			json.put("Body", body);
			json.put("From",  "vinci.datasource@gmail.com");
			json.put("To", to);
			boolean completed = JBPMClient.completeProcessApprover(
					processInstanceId, json,processUrl);
		}
		
		else if (StringUtils.equals(status,REQUEST_ACCEPTED ))
		{
			subject = "Request No " + request.getId() +" Approved" 
					+ "  - " + request.getTitle();
		
			body = "Your data request "
					+ request.getId()
					+ "   has been Accepted for review. " ;
					json.put("Subject", subject);
			json.put("fulfillmentDecision", "fulfilled");		
			json.put("Body", body);
			json.put("From",  "vinci.datasource@gmail.com");
			json.put("To", to);
			boolean completed = JBPMClient.completeProcessApprover(
					processInstanceId, json,processUrl);
		}
		
		else if (StringUtils.equals(status,RESULTS_NOT_ACCEPTED ))
		{
			subject = "Request No " + request.getId() + " Not Accepted"
					+ "  - " + request.getTitle();
		
			body = "The results for the research of "
					+ request.getId()
					+ "   have been reviewed and Not Accepted by " 
					+ request.getModifiedBy()
					+newline +request.getComments();
					json.put("Subject", subject);
			json.put("resultAcceptanceDecision", "reject");		
			json.put("Body", body);
			json.put("From",  to);
			json.put("To", from);
			boolean completed = JBPMClient.completeProcessApprover(
					processInstanceId, json,processUrl);
		}
		
		else if (StringUtils.equals(status,RESULTS_ACCEPTED ))
		{
			subject = "Request No " + request.getId() + " Accepted"
					+ "  - " + request.getTitle();
		
			body = "The results for the research of "
					+ request.getId()
					+ "   have been reviewed and Accepted by " 
					+ request.getModifiedBy();
				
					json.put("Subject", subject);
			json.put("resultAcceptanceDecision", "accept");		
			json.put("Body", body);
			json.put("From",  to);
			json.put("To", from);
			boolean completed = JBPMClient.completeProcessApprover(
					processInstanceId, json,processUrl);
		}
		
		
		return success;
	}
}
