/**
 * 
 */
package gov.va.genisis2.jbpm.controller;

import gov.va.genisis2.jbpm.configuration.JBPMRestConfig;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.remote.client.api.exception.RemoteCommunicationException;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 586338
 *
 */
@RestController
@RequestMapping("/jbpmService")
public class Genisis2JBPMController {

	private final org.slf4j.Logger Logger = LoggerFactory
			.getLogger(Genisis2JBPMController.class);

	private static final String PROCESS_ID = "workflow.workflow";

	private JBPMRestConfig engine;

	public JBPMRestConfig getEngine() {
		return engine;
	}

	@Autowired
	public void setEngine(JBPMRestConfig engine) {
		this.engine = engine;
	}

	@RequestMapping(value = "/start/{requestor}", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	public long startProcess(@PathVariable(value = "requestor") String requestor) {
		Logger.info("Genisis2JBPMController: Start Process for " + requestor);
		long id = 0;
		
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("requestorId", requestor);
		
		String taskUserId ="admin";  // Admin should kick off business process
		RuntimeEngine engine = this.getRuntimeEngine(taskUserId);
		KieSession ksession=null;
		
		try {
			 ksession = engine.getKieSession();
		} catch (Exception e) {
			Logger.error("Error while creating ProcessId for " + requestor
					+ " Reason" + e.getMessage());
			}
		if (ksession != null) {
			ProcessInstance processInstance = ksession.startProcess(PROCESS_ID,
					params);
			id = processInstance.getId();
			Logger.info("ProcessInstanceId=" + id + " created for Requestor: "
					+ requestor);
		} else {
			Logger.info("ksession is null");
		}
		
		Logger.info("ProcessInstanceId=" + id);
		return id;
	}

	@RequestMapping(value = "/task/requestor/{processId}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
	public boolean doTaskRequestor(
			@PathVariable(value = "processId") long processId,
			@RequestBody Map<String, Object> params) {
		boolean success = false;
		String user = (String) params.get("requestorId");
		success = completeTask(user, processId, params);
		return success;
	}

	@RequestMapping(value = "/task/approver/{processId}", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
	public boolean doTaskApprover(
			@PathVariable(value = "processId") long processId,
			@RequestBody Map<String, Object> params) {
		boolean success = false;
		String user = (String) params.get("approverId");
		success = completeTask(user, processId, params);
		return success;
	}

	private boolean completeTask(String taskUserId, long processInstanceId,
			Map<String, Object> params) {
		boolean success = false;

		long taskId = -1;
		List<TaskSummary> tasks = null;
		RuntimeEngine engine = this.getRuntimeEngine(taskUserId);
		KieSession ksession = engine.getKieSession();
		TaskService taskService = engine.getTaskService();

		if (engine == null || taskService == null) {
			return false;
		}
		try {
			tasks = taskService.getTasksAssignedAsPotentialOwner(taskUserId,
					"en-UK");
		} catch (RemoteCommunicationException rex) {
			Logger.error("Unable to get Tasks for " + "ProcessInstanceId: "
					+ processInstanceId + " Requestor: " + taskUserId
					+ " Reason" + rex.getMessage());
				}
	
		
		    if (tasks == null || tasks.equals("null"))
		    {
		    	Logger.info("No Tasks for "
					+ "ProcessInstanceId: " + processInstanceId
					+ " Requestor: " + taskUserId);
		    	return success;
		    }
			for (TaskSummary task : tasks) {
				if (task.getProcessInstanceId() == processInstanceId) {
					taskId = task.getId();
				}
			}
			
			if (taskId > 0) {
				taskService.release(taskId, taskUserId);
				taskService.claim(taskId, taskUserId);
				taskService.start(taskId, taskUserId);
				taskService.complete(taskId, taskUserId, params);
				success = true;
				Logger.info("Task completed succussfully for"
						+ "ProcessInstanceId: " + processInstanceId
						+ " Requestor: " + taskUserId);
			}
		
		
		return success;
	}

	private RuntimeEngine getRuntimeEngine(String user) {
		Logger.info("Genisis2JBPMController: Getting runtime for " + user);
		Map<String, String> map = engine.readPropertyValues();
		String deploymentId = map.get("deploymentId");
        String url = map.get("url"); 
        Logger.info("RunTime: " + "URL: " + url + " DeploymentId: " +deploymentId + " User: " +user );
		RuntimeEngine engine = null;
		{
			URL serverRestUrl = null;
			try {
				serverRestUrl = new URL(url);
			} catch (MalformedURLException e) {
				Logger.error("Workflow engine URL incorrect or missing" + url);;
			}
			engine = RemoteRuntimeEngineFactory.newRestBuilder()
					.addUrl(serverRestUrl).addDeploymentId(deploymentId)
					.addUserName(user).addPassword(user).disableTaskSecurity()
					.build();

			return engine;
		}
	}
}
