/**
 * 
 */
package gov.va.genisis2.jbpm.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.remote.client.api.RemoteRuntimeEngineFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

/**
 * @author 586338
 *
 */
@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
@PropertySource("file:${jboss.server.config.dir}/genisis2.properties")
public class JBPMRestConfig {

	@Value("${jbpm.workflow.deploymentId}")
	private String deploymentId;

	@Value("${jbpm.workflow.rest.url}")
	private String url;

	@Value("${jbpm.workflow.password}")
	private String password;

	@Value("${jbpm.workflow.processId}")
	private String processId;

	@Value("${jbpm.workflow.userId}")
	private String userId;

	public Map<String, String> readPropertyValues() {
		Map<String, String> properties = new HashMap<String, String>();
		properties.put("processId", processId);
		properties.put("deploymentId", deploymentId);
		properties.put("url", url);
		return properties;
	}

	@Bean
	public RuntimeEngine runtimeEngine() throws Exception {

		URL serverRestUrl = null;
		try {
			serverRestUrl = new URL(url);
		} catch (MalformedURLException e) {
			;
		}

		RuntimeEngine engine = RemoteRuntimeEngineFactory.newRestBuilder()
				.addUrl(serverRestUrl).addDeploymentId(deploymentId)
				.addUserName(userId).addPassword(password)
				.disableTaskSecurity().build();
		return engine;
	}

	@Bean
	public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
		return new PropertySourcesPlaceholderConfigurer();
	}

}