package gov.va.genisis2.jbpm.common.exception;

/**
 * @author Param Bindra
 *
 */
public enum ErrorSeverity {
	/**
	 * Warning - Business data eligible for processing with WARNING 
	 */
	WARN("warn"),
	
	/**
	 * Error - Business data not eligible for processing.
	 */ 
	ERROR("error"),
	
	/**
	 * Fatal Error - Fatal business error.
	 */
	FATAL("fatal");
	
	private String label;
	
	/**
	 * Default constructor.
	 * 
	 * @param int database value
	 */
	private ErrorSeverity( String label ) {
		 this.label = label;
	}
	
	/**
	 * Test for identity/equality.
	 * 
	 * @param enumObject
	 * @return boolean
	 */
	public boolean isEqual( ErrorSeverity enumObject ) {
		if( enumObject == null ) return false;
		return compareTo( enumObject ) == 0;
	}

	/**
	 * Returns Warning label
	 * @return
	 */
	public String getLabel() {
		return label;
	}

	public boolean isWarn() {
		return compareTo(WARN) == 0;
	}
	
	public boolean isError() {
		return compareTo(ERROR) == 0;
	}
	
	public boolean isFatal() {
		return compareTo(FATAL) == 0;
	}
}
