package gov.va.genisis2.jbpm.common.exception;

/**
 * ApplicationFault indicates a system level error
 * 
 * @author Param Bindra
 * 
 */
public enum ApplicationFault implements ErrorDetail {

	/** Spring Application context not initialzied */
	CONTEXT_NOT_INITIALIZED(1000, "Application factory not initialized ..."),

	/** Class not found under application classpath */
	CLASS_NOT_FOUND(2000, "Class not found in application classpath"),
	/** Error creating object */

	CLASS_CREATE_FAILURE(2001, "Error instantiating Object "),
	/** Method illegal access */

	METHOD_ILLEGAL_ACCESS(2002, "Method Illegal access"),
	/** No such method */

	NO_SUCH_METHOD(2003, "No such method defined"),

	ILLEGAL_DATABASE_STATE(2004, "Unexpected data in database"),

		
	/** Error XML encoding */
	XML_ENCODING_FAILURE(5000, "XML encoding error"),
	/** ILLEGAL ARUGUMENT IllegalArgumentException */
	ILLEGAL_ARUGUMENT(5500, "Illegal Argument Exception"),
	/** Unknown Error Exception */
	UNKNOWN_ERROR(5501, "Unknown exception occured"),

	/** Invalid provider */
	INVALID_PROVIDER(6000, "Provider not configured "),
	/** Invalid external service session */
	INVALID_SESSION(6500, "Service session is invalid");
	

	private Integer errorCode;
	/** Fault error message */
	private String errorMessage;

	private ApplicationFault(Integer errorCode, String errorMessage) {
		this.errorCode = errorCode;
		this.errorMessage = errorMessage;
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getMessageKey() {
		return errorMessage;
	}

	public String getErrorLabel() {
		return null;
	}

	public ErrorSeverity getErrorSeverity() {
		return ErrorSeverity.ERROR;
	}
}
