package gov.va.genisis2.jbpm.common.exception;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/**
 * ApplicationException indicates a system error
 * @author Param Bindra
 *
 */
public class ApplicationException extends RuntimeException {

	/** Serial Version ID */
	private static final long serialVersionUID = 1L;

	/** logger reference */
	private static Logger log = LogManager.getLogger(ApplicationException.class);

	private ErrorDetail error;

	public ApplicationException(Throwable cause) {
		this(null, cause);
	}
	
	public ApplicationException(ErrorDetail error) {
		this(error, null);
	}

	public ApplicationException(ErrorDetail error, Throwable cause) {
		super(cause);
		this.error = error;
		log.error(cause);
	}

	public ErrorDetail getError() {
		return error;
	}
	
	/**
	 * Returns the error message associated with exception
	 */
	@Override
	public String getMessage() {
		StringBuilder sb = new StringBuilder(" \n Application Exception : \n");
		
		if (error != null) {
			sb.append("Error Id: [" + error.getErrorCode() + "]\n");
			sb.append("Error Message: [" + error.getMessageKey() + "]\n");
		}
		
		if (this.getCause() != null) {
			sb.append("Caused by -->\n");
			sb.append(this.getCause().toString());
		}

		return sb.toString();
	}
}
